// Adapt Micro-C(ish) referenced within DDCCV.C to LCC (auto generated)

#define	U64		unsigned long
#define	Ulong	unsigned
#define	Ushort	unsigned short
#define	Uchar	unsigned char

void Strcpy(Uchar *d, Uchar *s)
{
	while(*d++ = *s++);
}
Ushort Strlen(Uchar *s)
{
	Ushort i;
	i = 0;
	while(s[i]) ++i;
	return i;
}
Uchar Toupper(Uchar c)
{
	if((c >= 'a') && (c <= 'z'))
		return c - 0x20;
	return c;
}

FILE *Fopen(Uchar fn[], Uchar *s)
{
	FILE	*fp;
	Uchar *d, o, buf[8];
	o = 0;
	d = buf;
a1:	switch(*d = *s++) {
	case 'v':	o |= 2;	goto a1;
	case 'q':	o |= 1;	goto a1;
	default	:	++d;	goto a1;
	case 0	:	; }
	if(!(fp = fopen(fn, buf))) {
		if(o & 2) {
			fputs("?Open`", stdout);
			fputs(fn, stdout);
			fputs("`\n", stdout); }
		if(o & 1)
			exit(0); }
	return fp;
}

void Fseek(FILE *fp, Ushort h, Ushort l)
{
	unsigned p;	Ushort f;
	p = (h << 16) | l;
	fseek(fp, p, 0);
	return;
}
void Ftell(FILE *fp, Ushort *h, Ushort *l)
{
	unsigned p;
	p = ftell(fp);
	*h = p >> 16;
	*l = p;
}

#include <conio.h>
#define	_KBS	0x008
#define	_K1		0x13B
#define	_K2		0x13C
#define	_K3		0x13D
#define	_K4		0x13E
#define	_K5		0x13F
#define	_K6		0x140
#define	_K7		0x141
#define	_K8		0x142
#define	_K9		0x143
#define	_K10	0x144
#define	_K11	0x285
#define	_K12	0x286
#define	_KUA	0x248
#define	_KDA	0x250
#define	_KLA	0x24B
#define	_KRA	0x24D
#define	_KHO	0x247
#define	_KEN	0x24F
#define	_KPU	0x249
#define	_KPD	0x251
#define	_KIN	0x252
#define	_KDL	0x253

#define	_CBS	0x07F
#define	_CF1	0x15E
#define	_CF2	0x15F
#define	_CF3	0x160
#define	_CF4	0x161
#define	_CF5	0x162
#define	_CF6	0x163
#define	_CF7	0x164
#define	_CF8	0x165
#define	_CF9	0x166
#define	_CF10	0x167
#define	_CF11	0x289
#define	_CF12	0x28A
#define	_CUA	0x28D
#define	_CDA	0x291
#define	_CLA	0x273
#define	_CRA	0x274
#define	_CHO	0x277
#define	_CEN	0x275
#define	_CPU	0x286
#define	_CPD	0x276
#define	_CIN	0x292
#define	_CDL	0x293
#define	_CTAB	0x194		// ^TAB

#define	_AF1	0x168
#define	_AF2	0x169
#define	_AF3	0x16A
#define	_AF4	0x16B
#define	_AF5	0x16C
#define	_AF6	0x16D
#define	_AF7	0x16E
#define	_AF8	0x16F
#define	_AF9	0x170
#define	_AF10	0x171
#define	_AF11	0x28B
#define	_AF12	0x28C
#define	_AUA	0x198
#define	_ADA	0x1A0
#define	_ALA	0x19B
#define	_ARA	0x19D
#define	_AHO	0x197
#define	_AEN	0x19F
#define	_APU	0x199
#define	_APD	0x1A1
#define	_AIN	0x1A2
#define	_ADL	0x1A3

#define	_RAIN	0x197

#define	_KPUA	0x148
#define	_KPDA	0x150
#define	_KPLA	0x14B
#define	_KPRA	0x14D
#define	_KPHO	0x147
#define	_KPEN	0x14F
#define	_KPPU	0x149
#define	_KPPD	0x151
#define	_KPIN	0x152
#define	_KPDL	0x153
#define	_CPSL	0x195	// Keypad ^/

#define	Vcolor	textattr

Ushort
	Vcols,
	Vlines,
	Vxpos,
	Vypos;
//Uchar
//	VcursorType,
//	VgsIns;			// Insert flag

#define	VLINES	25
#define	VCOLS	80

Vgotoxy(Ushort x, Ushort y)
{
	gotoxy((Vxpos = x)+1, (Vypos = y)+1);
}
void Vputc(Uchar c)
{
	Ushort w;
	switch(c) {
	case '\n' :
	case '\r' :
		putch(c);
		Vxpos = 0;
		return;
	case '\b' :
		putch(c);
		if(Vxpos)
			--Vxpos;
		return; }
	w = VCOLS;
	if(Vypos >= (VLINES-1))
		w = VCOLS-1;
	if(Vxpos < w) {
		putch(c);
		++Vxpos; }
}
void Vputs(Uchar *p)
{
	while(*p) Vputc(*p++);
}
// Clear to end of line
void _Vcleol_(void)
{
	Ushort w;
	w = VCOLS;
	if(Vypos >= (VLINES-1))
		w = VCOLS-1;
	while(Vxpos < w)
		Vputc(' ');
}
void Vcleol(void)
{
	Ushort x;
	x = Vxpos;
	_Vcleol_();
	Vgotoxy(x, Vypos);
}
void Vclscr(void)
{
	Ushort y;
	for(y = 0; y < VLINES; ++y) {
		Vgotoxy(0, y);
		_Vcleol_(); }
	Vgotoxy(0, 0);
}

// Initialize the video sub-system
Ushort Vopen(Uchar co)
{
	struct text_info x;
	textmode(C80);
	textattr(co);
	clrscr();
	Vxpos = Vypos = 0;
	gettextinfo(&x);
	Vcols = x.winright;
	Vlines = x.winbottom;
//	Vcursor(_NORMALCURSOR);
//	VgsIns = 255;
	return (Vcols*100)+Vlines;
}
// Close the video sub-system
void Vclose(void)
{
	textattr(7);
	clrscr();
	_setcursortype(_NORMALCURSOR);
}
Ushort Vgetc(void)
{
	Ushort c;
	switch(c = getch()) {
	case 0x00 : return getch() | 0x100;
	case 0xE0 : return getch() | 0x200;
	case '\r' : c = '\n';
	} return c;
}
Ushort Vgetk(void)
{
	Ushort k;
	switch(k = Vgetc()) {
	case _KPUA: return _KUA;
	case _KPDA: return _KDA;
	case _KPRA:	return _KRA;
	case _KPLA: return _KLA;
	case _KPHO: return _KHO;
	case _KPEN: return _KEN;
	case _KPPU:	return _KPU;
	case _KPPD:	return _KPD;
	case _KPIN:	return _KIN;
	case _KPDL:	return _KDL; }
	return k;
}

// Format to string routine, format operands are passed
// as a pointer to the calling functions argument lists.
Ushort _format_(char *outptr, unsigned *aptr)
{
	unsigned width, value, i;
	char left, zero, minus, c, *iptr, *optr, *ptr, outstk[11];

	iptr = (char*)*aptr;				// Get input string
	optr = outptr;						// So we can return length
	while(c = *iptr++) {
		if(c == '%') {					// format code
			c = *iptr++;
			*(ptr = &outstk[10]) = left = minus = width = value = i = 0;
			zero = ' ';					// Assume pad with ' '
			if(c == '-') {				// left justify
				left = 255;
				c = *iptr++; }
			if(c == '0')				// pad with '0'
				zero = '0';
			while((c >= '0') && (c <= '9')) {	// Field width
				width = (width * 10) + (c - '0');
				c = *iptr++; }

			value = *++aptr;

			switch(c) {
				case 'd' :				// decimal (signed)
					if(value > 32767) {
						value = 0 - value;
						++minus; }
				case 'u' :				// unsigned
					i = 10;
					break;
				case 'x' :				// hexidecimal
					i = 16;
					break;
				case 'o' :				// octal
					i = 8;
					break;
				case 'c' :				// character
					*--ptr = value;
					break;
				case 's' :				// string
					ptr = (char*)value;
					break;
				default:				// all others
					--aptr;
					*--ptr = c; }

			if(i)		// for all numbers, generate the ASCII string
				do {
					if((c = (value % i) + '0') > '9')
						c += 7;
					*--ptr = c; }
				while(value /= i);

			if(minus) {					// output sign if any
				*optr++ = '-';
				if(width)
					--width; }

			if(width && !left) {		// pad if right justify enabled
				for(i = strlen(ptr); i < width; ++i)
					*optr++ = zero; }

			i = 0;						// move in data
			value = width - 1;
			while((*ptr) && (i <= value)) {
				*optr++ = *ptr++;
				++i; }

			if(width && left) {			// pad if left justify enabled
				while(i < width) {
					*optr++ = zero;
					++i; } } }
		else				// not a format code, simply copy the character
			*optr++ = c; }

	*optr = 0;
	return optr - outptr;
}
Ushort Printf(Uchar *format, ...)
{
	unsigned l;
	Uchar buf[256];
	l = _format_(buf, (unsigned*)&format);
	fputs(buf, stdout);
	return l;
}
Ushort Vprintf(Uchar *format, ...)
{
	Ushort l;
	Uchar buf[128];
	l = _format_(buf, (unsigned*)&format);
	Vputs(buf);
	return l;
}
void Error(Uchar *format, ...)
{
	Uchar buf[256];
	_format_(buf, (unsigned*)&format);
	fputs(buf, stderr);
	exit(0);
}
