// RECENT
#include <stdio.h>
#include <file.h>

#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	POOL	16384
#define	TREES	16
#define	NPATS	16
#define	FILES	2048
#define	INIFILE	"CHANGED.INI"

#define	O_REV	0x01
#define	O_DIR	0x02
#define	O_NINI	0x04
#define	O_TREE	0x08
#define	O_BARE	0x10

#define	LOW		-1
#define	HIGH	1

#define	COMPARE	Compare() == Cyes

unsigned
	Seg,
	Sh, Sl, At, Ti, Da,
	Cda, Cti,
	Cyes = HIGH,
	Files,
	ISyes, ISno, IScur,
	Dtop,
	Ttop,
	Ntop,
	Ftop,
	Ptop,
	Fsize = 256,
	Mlist[256],
	Ftext[FILES],
	Fda[FILES+1],
	Fti[FILES+1];
FILE
	*fp;
unsigned char
	*Ptr,
//	*Fname,
//	*Fext,
	*Tree[TREES],
	*Npat[NPATS],
	Opt,
	Fname,
	Fext,
	Dir[256],
	Temp[256],
	Pattern[128],
	Xpattern[128],
	Pool[POOL];

#include "R:\\Help.H"

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
	exit(-1);
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			error("String pool overflow"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

// Skip to non-blank
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	Debug(printf("Match '%s'", name));
//	Debug(printf(" '%s'\n", pattern));

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}


void showtd(unsigned ti, unsigned da)
{
	unsigned j, k;
	if(Opt & O_BARE)
		return;
	j = (k = (ti >> 11) & 0x1F) % 12;
/*D4*/	printf("%04u-%02u-%02u", (da>>9)+1980,		(da>>5)&15, da&31);
//D2*/	printf("%02u-%02u-%02u", ((da>>9)+80)%100,	(da>>5)&15, da&31);
//t12*/	printf(" %3u:%02u%c",(j)?j:12,	(ti>>5)&63,	(k>11)?'p':'a');
//T12*/	printf(" %3u:%02u:%02u%c",(j)?j:12,	(ti>>5)&63,	(ti&31)*2, (k>11)?'p':'a');
//t24*/	printf(" %3u:%02u", ti>>11,		(ti>>5)&63);
/*T24*/	printf(" %3u:%02u:%02u ", ti>>11,	(ti>>5)&63, (ti&31)*2);
}

void Fstore(unsigned f)
{
	unsigned i, j;
	unsigned char *p;

	strcpy(Dir+Dtop, Temp);
	Fti[f] = Ti;
	Fda[f] = Da;
	j = (Ftext[f] = i = f * Fsize) + Fsize;
	p = Dir;
	do {
		poke(Seg, i++, *p);
		if(i == j)
			error("Pathname too long (lower -Fn)"); }
	while(*p++);
}

unsigned Compare(unsigned f)
{
	unsigned  d, t;
	d = Fda[f];
	if(Cda < d)	goto rl;
	if(Cda > d)	goto rh;
	t = Fti[f];
	if(Cti < t) {
rl:		return LOW; }
	if(Cti > t) {
rh:		return HIGH; }
	return 0;
}

void AddFile(void)
{
	unsigned i, j;
	if(Ftop < Files) {
		Fstore(Ftop++);
//printf("A%u'%s'%u\n", Ftop, Dir, Files);
		return; }
	i = 0;
	j = -1;
	Cda = Da;
	Cti = Ti;
	while(i < Ftop) {
		if(Compare(i) == Cyes) {
			Cda = Fda[i];
			Cti = Fti[i];
			j = i; }
		++i; }
	if(j != -1)
		Fstore(j);
}

void DoDir(void)
{
	unsigned i, dt, pt;
	dt = Dtop; pt = Ptop;
	while(Dir[Dtop]) ++Dtop;
	if(Dtop) switch(Dir[Dtop-1]) {
	default	:	Dir[Dtop++] = '\\';
	case ':':
	case'\\':	; }
	if(Opt & O_DIR) {
		Dir[Dtop] = 0;
		Ps("Dir: ");
		Ps(Dir);
		Pc('\n'); }
	strcpy(Dir+Dtop, "*.*");
//printf("Dd'%s'%s'\n", Dir, Pattern);
	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da))
		goto ex;
	do {
#ifdef _DVM_
		if(At & (DIRECTORY)) {
			if(*Temp != '.')
				Pstring(Temp);
			continue; }
#else
		if(At & (DIRECTORY|HIDDEN|SYSTEM|VOLUME)) {
			if(!(At & (HIDDEN|SYSTEM|VOLUME))) {
				if(*Temp != '.')
					Pstring(Temp); }
			continue; }
#endif
		if(Fmatch(Temp, Pattern)) {
			for(i=0; i < Ntop; ++i) {
				if(Fmatch(Temp, Npat[i]))
					goto a1; }
			AddFile();
a1:			; } }
	while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
	i = pt;
	while(i < Ptop) {
		strcpy(Dir+Dtop, Pool+i);
		DoDir();
		while(Pool[i++]); }
ex:	Dtop = dt; Ptop = pt;
}

void Sort(void)
{
	unsigned i, j, k;
	for(i=0; i < Ftop; ++i) {
		Cda = Fda[i];
		Cti = Fti[i];
		k = j = i;
		while(++j < Ftop) {
			if(Compare(j) == Cyes) {
				Cda = Fda[j];
				Cti = Fti[j];
				k = j; } }
		if(k != i) {
			j = Fda[i];
			Fda[i] = Fda[k];
			Fda[k] = j;
			j = Fti[i];
			Fti[i] = Fti[k];
			Fti[k] = j;
			j = Ftext[i];
			Ftext[i] = Ftext[k];
			Ftext[k] = j; } }
}

void help(void)
{
#if 7
	unsigned char c, *p;
	p = Help;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
#else
	Ps("[H]");
#endif
	exit(0);
}

unsigned DoFile(void)
{
	unsigned i;
	Fname = i = 0;
a1:	Fext = 0;
a2:	switch(Ptr[i++]) {
	case ':':
	case'\\':	Fname = i;	goto a1;
	case '.':	Fext = i;
	default	:				goto a2;
	case 0	:	}
	return i-1;
}

unsigned ISbits(void)
{
	unsigned c, v;
	unsigned char *p;
	skip(); trim();
	p = Ptr;
	v = 0;
	Debug(("[ISb'%s'%x", Ptr, v))
	while(c = *Ptr) {
		if((c -= '0') > 9)
			goto er;
		v |= (1 << c);
		++Ptr; }
	Debug(("=%x]", v))
	if(Ptr <= p) {
er:		error("BadBITs'%s'", p); }
	return v;
}

void Wild(void)
{
	unsigned i;
	unsigned char w;
	i = w = 0;
a1:	switch(Dir[i]) {		
	case '*':
	case '?':	w = 7;
	default	:	++i;	goto a1;
	case 0	:	; }
	if(!w) {
		switch(Dir[i-1]) {
		default	:	Dir[i++] = '\\';
		case ':':
		case'\\':	; }
		strcpy(Dir+i, "*"); }
}

void Arg(unsigned ie)
{
	unsigned char c;

	switch(skip()) {
	case '?':
he:		help();
	case '-':
	case '/':	++Ptr;
a1:		switch(c = toupper(*Ptr++)) {
		default	:	--Ptr;
			ISyes = ISbits() | 0x8000;
			return;
		case '?':	goto he;
/*ChtTxt R:\Help.h
use:	RECENT	tree\pattern... [options]

opts:	-B				Bare output (no time)
		-D				show Directories scanned
		-F1-2048		set number of Files to display	[20]
		-Ifile[.INI]	set Initialization file			[CHANGED.INI]
			Otherwise RECENT will check %DDCDATA%\CHANGED.INI
		-N				do Not look in CHANGED.INI for more arguments
		-O				show Oldest files				(otherwise newest)
		-R				Reverse output					(top of list last)
		-T				show Trees processed
		-!pattern		don't look at files matching this pattern
		-0-9..			force INI sections
		-+0-9..			add to ""
		--0-9..			remove from ""

Show recently changed files over large tree(s).		See: CHANGED.TXT

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
		case '`':	Ps(Ptr); Pc('\n');	return;
		case '+':	ISyes |= ISbits();	return;
		case '-':	ISno  |= ISbits();	return;
		case '!':
			if(Ntop >= NPATS)
				error("Too many -!'s");
			strupr(Ptr);
			Npat[Ntop++] = Pstring(Ptr);
			return;
		case 'I':
			if(ie) error("Can't set -I in .INI");
			strcpy(Temp, Ptr);
			return;
		case 'F':
			if(!Files) {
				Files = atoi(Ptr);
				if((Files-1) >= 2048)
					error("-F must be 1-2048");
				Fsize = 65535/Files;
				if(!((Fsize+1)*Files))
					++Fsize; }
			return;
		case 'O':	Cyes = LOW;			break;
		case 'B':	c = O_BARE;			goto a2;
		case 'D':	c = O_DIR;			goto a2;
		case 'N':	c = O_NINI;			goto a2;
		case 'R':	c = O_REV;			goto a2;
		case 'T':	c = O_TREE;	
a2:			Opt |= c; }
		if(*Ptr)
			goto a1;
		return; }
	if(!ie) {
		DoFile();
		if(!Fname) {
			strcpy(Xpattern, Ptr);
			return; } }
	if(Ttop >= TREES)
		error("Too many trees");
	Tree[Ttop++] = Pstring(Ptr);
}

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

main(int argc, char *argv[])
{
	unsigned i, j;
	unsigned char c;

	MemTst(7);
	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		Arg(0); }

	if(Opt & O_NINI) goto a2;
	if(*(Ptr = Temp)) {
		i = DoFile();
		if(Fname) switch(Temp[Fname-1]) {
			case ':':
			case'\\':
				strcpy(Temp+Fname, INIFILE);
			default	:	; }
		fp = fopen(Temp, "rvq");
		goto a1; }
	if(fp = fopen(INIFILE, "r")) goto a1;
	if(getenv("DDCDATA", Dir)) {
		i = 0; while(Dir[i]) ++i;
		if(i) switch(Dir[i-1]) {
			default	:	Dir[i++] = '\\';
			case ':':
			case'\\':	; }
		strcpy(Dir+i, INIFILE);
		if(fp = fopen(Dir, "rv")) {
a1:			IScur = 0xFFFF;
			while(fgets(Ptr = Dir, sizeof(Dir)-1, fp)) {
				switch(skip()) {
				case ':':
					switch(toupper(*++Ptr)) {
					case 'R':	++Ptr;
						if(!(ISyes & 0x8000))
							ISyes |= ISbits();
						Debug(("[:%x]", ISyes))
					case 'C':
						continue; }
					IScur = ISbits();
				case ';':
				case 0	:	continue; }
				if((~ISno) & IScur & ISyes) {
					trim();
					Debug(("A'%s'\n", Ptr))
					Arg(7); } }
			fclose(fp); } }

a2:	if(!Files)
		Files = 20;
	Debug(("[#%u L%u]\n", Files, Fsize))
	if(!Ttop) {
		strcpy(Temp, "_:\\");
		getdir(Temp+3);
		*Temp = get_drive()+'A';
		Debug(("D'%s'\n", Temp))
		Tree[Ttop++] = Pstring(Temp); }
//		if(!*Xpattern) *Xpattern = '*'; }

	Seg = alloc_seg(4096);
	i = 0;
	do {
		pokew(Seg, i, 0); }
	while(i -= 2);

	for(i=0; i < Ttop; ++i) {
		strcpy(Ptr = Dir, Tree[i]);
		Wild();
		if(Opt & O_TREE) {
			Ps("Tree: ");
			Ps(Dir);
			Pc('\n'); }
		DoFile(0);
		j = Fname;
		strcpy(Pattern, *Xpattern ? Xpattern : Dir+j);
		Debug(("P1'%s'\n", Pattern))
		strcpy(Dir+Fname, "*.*");
		strupr(Pattern);
		if((Fname > 3) || (Dir[1] != ':'))
			--Fname;
		Dir[Fname] = Dtop = 0;
		DoDir();
	}

	Sort();

	if(Opt & O_REV) {
		i = Ftop;
		while(i) {
			j = Ftext[--i];
			showtd(Fti[i], Fda[i]);
			while(c = peek(Seg, j++))
				Pc(c);
			Pc('\n'); }
		return; }
	for(i=0; i < Ftop; ++i) {
		showtd(Fti[i], Fda[i]);
		j = Ftext[i];
		while(c = peek(Seg, j++))
			Pc(c);
		Pc('\n'); }
	MemTst(0);
}
//ChtCmd cc recent -pof
