// RECMD
//ChtTxt R:\Help.h
#include <stdio.h>
#include <file.h>
#include <dvmvideo.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	LINES	24
#define	POOL	16384
#define	SRCS	10
#define	NEGS	25

#define	VNORM	0x17
#define	VHIL1	0x71
#define	VHIL2	0x31

#define	O_NREC	0x01
#define	O_DRY	0x02

unsigned
	Vtop, Pos,			// Screen Top/Position
	Vsc,				// "" color
	Seg,				// Extern segment
	Sh, Sl, At, Ti, Da,	// Find information
	Fcount,				// Files processed
	Dtop,				// Top of Dir
	Ptop,				// "" string pool
	Ftop,				// "" File list
	Stop,				// "" source list
	Ntop,				// "" Not list
	Fsel[256],			// File select/sort
	Fsh[256],			// "" sizeH
	Fsl[256],			// "" sizeL
	Fda[256],			// "" Date
	Fti[256];			// "" Time
unsigned char
	*Ptr,				// General pointer
	*Ptr1,				// ""
	*Ptr2,				// ""
	*Srcs[SRCS],		// Source list
	*Negs[NEGS],		// Not list
	Opt,				// Command options
	Vmode,				// Video mode
	C, D, E,			// Global char chars
	Temp[128],			// Temp location
	Dir[256],			// Working directory
	PatBuf[256],		// Pattern buffer
	Pool[POOL];			// String pool

/*ChtTxt Ehelp
The commands offered by RECMD.COM/.DVM may be customzied using ESP:

Each command string begins with the key character to launch the command,
followed by the text of the command which may include these "special"
character:

	0xF0	command is performed by exec(command,args) and this sets the
				boundary between "command" and "args" strings. (*)
	0xF1	insert the full path\name to the selected file
	0xF2	insert name only of ""

(*)	When performed by exec() [instead of system()] launching has less overhead
	but no "shell" operations (like redirection, pipes etc.) are supported!
 Use of 0xF0 is important for .DVM because exec() launches a .DVM within the
 running virtual system, but system() passes the command back to the host!
*/
#ifdef _DVM_
	#define	DIRTST	DIRECTORY
	unsigned char
	___1[]		= { 0xA7, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 0 },
	Cmd1[65]	= "C:copy \xF1 R:\\",
	Cmd2[65]	= "Tvlt\xF0\xF1",
	Cmd3[65]	= "Xvlx\xF0\xF1",
	Cmd4[65]	= "Eedt \xF1",
	Cmd5[65]	= "D?:del \xF1",
	Cmd6[65]	= "",
	Cmd7[65]	= "",
	Cmd8[65]	= "",
	Cmd9[65]	= "",
	Cmd0[65]	= "",
	___2 = 0xA7;
#else
	#define	DIRTST	(DIRECTORY|VOLUME|HIDDEN)
	unsigned char
	___1[]		= { 0xA7, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 0 },
	Cmd1[65]	= "C:copy \xF1 R:\\",
	Cmd2[65]	= "Tvlt \xF1",
	Cmd3[65]	= "Xvlx \xF1",
	Cmd4[65]	= "Eedt \xF1",
	Cmd5[65]	= "D?:del \xF1",
	Cmd6[65]	= "",
	Cmd7[65]	= "",
	Cmd8[65]	= "",
	Cmd9[65]	= "",
	Cmd0[65]	= "",
	___2 = 0xA7;
#endif

extern unsigned char *Htext[];

#include "R:\\Help.h"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

void Pc(unsigned char c)
{
	if(Vmode) {
		Vputc(c);
		return; }
	putc(c, stdout);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	if(Vmode) {
		Vclose();
		Vmode = 0; }
//	if(Line) printf("%u: ", Line);
	Ps(buf);
	exit(-1);
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

void ShowTD(unsigned ti, unsigned da)
{
	unsigned j, k;
//	if(Opt & O_BARE)
//		return;
	j = (k = (ti >> 11) & 0x1F) % 12;
/*D4*/	Vprintf("%04u-%02u-%02u", (da>>9)+1980,		(da>>5)&15, da&31);
//D2*/	Vprintf("%02u-%02u-%02u", ((da>>9)+80)%100,	(da>>5)&15, da&31);
//t12*/	Vprintf(" %3u:%02u%c",(j)?j:12,	(ti>>5)&63,	(k>11)?'p':'a');
//T12*/	Vprintf(" %3u:%02u:%02u%c",(j)?j:12,	(ti>>5)&63,	(ti&31)*2, (k>11)?'p':'a');
//t24*/	Vprintf(" %3u:%02u", ti>>11,		(ti>>5)&63);
/*T24*/	Vprintf(" %3u:%02u:%02u ", ti>>11,	(ti>>5)&63, (ti&31)*2);
}

void ShowSiz(void)
{
	unsigned l[2];
	unsigned char buf[16];
	l[1] = Sh;
	*l = Sl;
	ltoa(l, buf, 10);
	Vprintf("%11s ", buf);
}

void Pseg(void)
{
	unsigned i;
	unsigned char *p;
	static unsigned Ld, Lt, Lp;

	if(Ftop < 256) {
		Fsel[Ftop] = Ftop;
		Fda[Ftop] = Da;
		Fti[Ftop] = Ti;
		Fsh[Ftop] = Sh;
		Fsl[Ftop] = Sl;
		i = Ftop << 8;
		p = Dir;
		do {
			poke(Seg, i++, *p); }
		while(*p++);
		if(++Ftop == 256)
			goto a2;
		return; }

	if(Da < Ld)	return;
	if(Da > Ld)	goto a1;
	if(Ti < Lt)	return;
a1:	Fda[Lp] = Da;
	Fti[Lp] = Ti;
	Fsh[Lp] = Sh;
	Fsl[Lp] = Sl;
	i = Lp << 8;
	p = Dir;
	do {
		poke(Seg, i++, *p); }
	while(*p++);

a2:	Ld = Lt = 0xFFFF;
	for(i=0; i < Ftop; ++i) {
		if(Fda[i] > Ld)	continue;
		if(Fda[i] < Ld)	goto a3;
		if(Fti[i] < Lt)	{
a3:			Ld = Fda[i];
			Lt = Fti[i];
			Lp = i; } }
}

void Gseg(unsigned i)
{
	unsigned char c, *p;
	Ti = Fti[i];
	Da = Fda[i];
	Sh = Fsh[i];
	Sl = Fsl[i];
	p = Temp;
	i <<= 8;
	do {
		c = peek(Seg, i++); }
	while(*p++ = c);
}

unsigned Fname(void)
{
	unsigned i, j;
	unsigned char *p, c, w;
	Debug(("Dir'%s'", Dir))
	Dtop = i = j = w = 0;
/*ChtTxt Phelp
When specifing file locations, RECMD asumes any parts without "wildcard" chars
('*'or'?') are directories, and anythimg past the first wildcard is a filespec
to match:
	C:\Files\X		becomes	C:\Files\X\*
	C:\Files\X.*	becomes	C:\Files\X.*

additional filespecs my be appended:
	...\spec		also process files matching this
	.../spec		do not ""
*/
a1:	switch(Dir[i++]) {
	case ':':
	case'\\':	j = i;
	Debug(("[%u]", j))
	default	:	goto a1;
	case '?':
	case '*':
	case '/':
		w = 15;
	case 0	:	; }
	Debug(("%s'%u\n", Dir+j, j))
	if(w)
		p = Dir+j;
	else {
		j = i;
		p = "*"; }
	strcpy(PatBuf, p);
	strupr(PatBuf);
	Dir[j] = c = w = 0;
	while(Dir[Dtop]) {
		w = c;
		c = Dir[Dtop++]; }
	if(c == '\\') {
		if(w != ':')
			Dir[--Dtop] = 0; }
	if(!*Dir) {
		strcpy(Dir, "_:\\");
		getdir(Dir+3);
		*Dir = get_drive()+'A'; }
	Debug(("Fn'%s'%s'\n", Dir, PatBuf))
}

unsigned NxtPat(void)
{
//unsigned char *p; p = Ptr;
	if(D)
		*Ptr2 = D;
	Debug(("Nx1'%s'", Ptr))
	switch(C = *Ptr) {
	case 0	:
		Debug(("0\n"))
		return 0;
	case '/':
	case'\\':	++Ptr; }
	Ptr1 = Ptr;
a1:	switch(D = *Ptr) {
	default	:	++Ptr;	goto a1;
	case '/':
	case'\\':	*(Ptr2 = Ptr) = 0;
	case 0	:	; }
	Debug(("='%s'\n", p))
	return 255;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

	Debug(("Match '%s'", name))
	Debug((" '%s'\n", pattern))

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
		if(toupper(*name++) != c)
//		if(*name++ != c)
			return 0; }
}

void DoDir(void)
{
	unsigned i, dt, pt;

	pt = Ptop; dt=Dtop;
	C = 0;
	while(Dir[Dtop]) C = Dir[Dtop++];
	switch(C) {
	default	:	Dir[Dtop++] = '\\';
	case ':':
	case'\\':	; }
	strcpy(Dir+Dtop, "*.*");

	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da))
		goto ex;
	do {
		if(At & DIRTST) {
#ifndef _DVM_
			if(At & (VOLUME|HIDDEN))
				continue;
#endif
			if((*Temp != '.') && !(Opt & O_NREC))
				Pstring(Temp);
			continue; }
		i = 0;
		while(i < Ntop) {
			if(Fmatch(Temp, Negs[i++]))
				goto a2; }

		Ptr = PatBuf;
		i = 0;	//?
		Debug(("?"))
		for(;;) {
			E = D;
			if(!NxtPat())
				break;
			Debug(("%u'%s'%s'", (C == 0x2F), Temp, Ptr1))
			if(C == 0x2F) {
				if(Fmatch(Temp, Ptr1))
					goto a2;
				i |= 4;
				continue; }
			i |= 2;
			if(Fmatch(Temp, Ptr1))
				i |= 1; }
		Debug((" E%02x\n", i))
		if(i & 1)	goto a1;	// Y
		if(i & 2)	goto a2;	// !Y
		if(i & 4)	goto a1;	// !N
		continue;
a1:		strcpy(Dir+Dtop, Temp);
		Debug(("'%s'\n", Dir))
		Pseg();
		++Fcount;
a2:	} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);

	i = pt;
	while(i < Ptop) {
		strcpy(Dir+Dtop, Pool+i);
		while(Pool[i++]);
		DoDir(); }

ex:	Dtop = dt;
	Ptop = pt;
}
register Prompt(unsigned args)
{
	unsigned char *p, c, d, buf[128];
	_format_(nargs()*2+&args, p=buf);
	do {
		if(!(d = *p++))
			Error("?1"); }
	while !(d & 0x80);
	Ps(p);
a1:	if((c = Vmode ? Vgetc() : kbget()) == 0x1B)
		Error("?Abort");
	c = toupper(c);
	p = buf;
	do {
		if(*p & 0x80)
			goto a1; }
	while(*p++ != c);
	if(d & 2) Pc(c);
	if(d & 1) Pc('\n');
	return c;
}

void DoCmd(unsigned char *p, unsigned char ng)
{
	unsigned i, j;
	unsigned char *a, cf;
	Ptr1 = Dir;
	a = cf = 0;
a0:	switch(*++p) {
	case ':':	cf |= 1;	goto a0;
	case '?':	cf |= 2;	goto a0; }

a1:	switch(*Ptr1 = *p++) {
	default	:	++Ptr1;	goto a1;
	case 0xF0:
		*Ptr1 = 0;
		a = ++Ptr1;
		goto a1;
	case 0xF1:	j = 0;
a2:		strcpy(Ptr1, PatBuf+j);
		while(*Ptr1) ++Ptr1;
		goto a1;
	case 0xF2:
		i = j = 0;
a3:		switch(PatBuf[i++]) {
		case ':':
		case '\\':	j = i;
		default	:	goto a3;
		case 0	: goto a2; }
	case 0	:	; }

	if(!ng)
		Ps("> ");
	Ps(Dir);
	if(a) {
		Pc(' ');
		Ps(a); }

	if(ng)	return;

	Pc('\n');
	if(!(Opt & O_DRY)) {
		if(cf & 2) {
			if(Prompt("YN\x83Are you SURE? ") != 'Y')
				return; }
		if(a)
			exec(Dir, a);
		else
			system(Dir);
		if(!(cf & 1))
			return; }

	Prompt(" \x80\nPress SPACE!");
}

void Sort(void)
{
	unsigned i, j, k, l;
	for(i=0; i < Ftop; ++i) {
		k = Fsel[i];
		for(j=i+1; j < Ftop; ++j) {
			if((l = Fsel[j]) == k)
				continue;
			if(Fda[l] > Fda[k])	goto a1;
			if(Fda[l] < Fda[k])	continue;
			if(Fti[l] > Fti[k]) {
a1:				k = Fsel[j];
				Fsel[j] = Fsel[i];
				Fsel[i] = k; } } }
}

Color(unsigned char c)
{
	if(c != Vsc)
		Vcolor(Vsc = c);
}

void Neg(void)
{
	unsigned char c;
a1:	Ptr1 = Ptr;
a2:	switch(c = *Ptr) {
	default	:	++Ptr;	goto a2;
	case ':':	*Ptr = 0;
	case 0	:	; }
	if(*Ptr1) {
		if(Ntop >= NEGS)
			Error("?#neg");
		Debug1(("N'%s'\n", Ptr1))
		strupr(Negs[Ntop++] = Pstring(Ptr1)); }
	if(c) {
		++Ptr;
		goto a1; }
}
void ShowCmds(unsigned l)
{
	unsigned i;
	Ptr = Cmd1;
	i = 0;
	do {
		if(l) {
			if(!*Ptr) goto a1;
			Vgotoxy(7, l++);
			Vprintf("'%c' ", *Ptr); }
		else
			printf("   %u ", ++i % 10);
		DoCmd(Ptr, 255);
		if(!l)
			Pc('\n');
a1:		Ptr += sizeof(Cmd1); }
	while(Ptr < &___2);
}
void Help(void)
{
	unsigned i;
	unsigned char **hp, *p, c;
//	Pr("[Help%02x]", C);
	hp = Htext;
	i = 0;
	while(C) {
		p = *hp++;
		if(C & 1) {
			if(i) {
				while(--i) Pc('-');
				Pc('\n'); }
			while(c = *p++) {
				if(c & 0x80) {
					while(c-- & 0x7F)
						Pc(' ');
					continue; }
				Pc(c); }
			i = 75; };
		C >>= 1; }
}

main(int argc, char *argv[])
{
	unsigned i, j;
	unsigned char c;

	MemTst(7);

	Seg = alloc_seg(4096);
	i = 0;
	while(++i < argc) {
		switch(*(Ptr = argv[i])) {
		case '?':	goto he;
		case '-':	++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
			case '?':	switch(toupper(*Ptr)) {
				default	:	C = 0x04;	goto he1;
				case 'E':	C = 0x08;	goto he1;
				case 'P':	C = 0x10;	goto he1;
				case 'A':	C = 0x1E;	goto he1; }
			C = 4;	goto he1;
/*ChtTxt Help1
	-?P		specifying file Paths
	-?E		customizing with ESP
	-?A		show All help
*/
/*ChtTxt Mhelp
Interactive RECent file CoMmanDs:

use:	RECMD	path ... [:]pattern... [options]

opts:	-D		Dry run - show without doing
		-R		do not Reurse into subdirectories
		-?[h]	Show more help.

RECMD interactively lets you select from the most recent files(*) occuring
in the specified path(s), and perform a selection of predefined commands on
them (see -?E).

	* To keep things fast/simple, RECMD is limited to a maximum of 256 files.

[:] Leading ':' means filenames matching this pattern should be ignored.

Press '?' to get help within in interactive screen!

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'Z':	c = 0x80; goto o2;
			case 'D':	c = O_DRY;	goto o2;
			case 'R':	c = O_NREC;
o2:				Opt |= c; }
			if(*Ptr) goto o1;
			continue;
		case ':':	++Ptr;
			Neg();
			continue; }
		Debug(("S+%u'%s'\n", Stop, Ptr))
		if(Stop >= SRCS)
			Error("?#srcs");
		Srcs[Stop++] = Pstring(Ptr); }

	if(!Stop) {
he:		C = 2;
he1:	strcpy(PatBuf, "[file]");
		Help();
		return; }

	for(i=0; i < Stop; ++i) {
		Debug(("S-%u'%s'\n", i, Srcs[i]))
		strcpy(Dir, Srcs[i]);
		Fname();
		Dtop = 0;
		DoDir(); }

	if(Opt & 0x80) goto ex;
	if(!Ftop)
		Error("No files!");
	Sort();

#if 0
	for(i=0; i < Ftop; ++i) {
		Gseg(Fsel[i]);
		ShowTD(Ti, Da);
		printf(" %4x%04x '%s'\n", Sh, Sl, Temp); }
	return;
#endif

a0:	Vopen(0x17);
	Vmode = 255;
a1:	if(Pos & 0xF000)	Pos = 0;
	if(Pos >= Ftop)		Pos = Ftop-1;
	if(Pos < Vtop)		Vtop = Pos;
	while((i = Vtop+LINES) <= Pos)
		++Vtop;
	for(i=0; i < LINES; ++i) {
		Vgotoxy(0, i);
		j = Vtop+i;
//		Vprintf("%-5u", j);
		if(j >= Ftop) {
			if(j == Ftop) {
				Color(VHIL2);
				Vputs("[END]"); }
			goto a2; }
		Color((j == Pos) ? VHIL1 : VNORM);
		Gseg(Fsel[j]);
		ShowTD(Ti, Da);
//		Vprintf(" %04x%04x ", Sh, Sl);
		ShowSiz();
		if(j == Pos)
			strcpy(PatBuf, Temp);
		Vputs(Temp);
a2:		Color(VNORM);
		Vcleol(); }
	Vgotoxy(25, LINES);
	Vprintf("%3u/%-3u from %u", Pos+1, Ftop, Fcount);
b1:	switch(i = Vgetk()) {
	default	:
		Ptr = Cmd1;
		i = toupper(i);
		do {
			if(*Ptr == i)
				goto b2;
			Ptr += sizeof(Cmd1); }
		while(Ptr < &___2);
	case 0:
		goto b1;
b2:		Vclose();	
		Vmode = 0;
		DoCmd(Ptr, 0);
		goto a0;
/*ChtTxt Ihelp

	  Up/Dn		move by one line
	PgUp/PgDn	  ""		screen
	Home/End	  "" to start/end
	   ESC		Exit
*/
	case _KUA:	--Pos;		goto a1;
	case _KDA:	++Pos;		goto a1;
	case _KPU:	Pos-=LINES;	goto a1;
	case _KPD:	Pos+=LINES;	goto a1;
	case _KHO:	Pos = 0;	goto a1;
	case _KEN:	Pos=Ftop-1;	goto a1;
	case  '?':
		Vclscr();
		C = 1;
		Help();
		Ptr	 = Cmd1;
		i = 5;
		do {
			if(*Ptr) {
				Vgotoxy(7, ++i);
				Vprintf("'%c' ", *Ptr);
	 			DoCmd(Ptr, 255);}
			Ptr += sizeof(Cmd1); }
		while(Ptr < &___2);
		Vgotoxy(25, LINES);
		Prompt(" \x81Press SPACE!");
		Vclscr();
		goto a1;
	case 0x1B:	; }
	Vclose();
ex:
	Debug1(("Ftop=%u\n", Ftop))
	MemTst(0);
}
//								1		2		4		8	10
unsigned char *Htext[] = { &Ihelp, &Mhelp, &Help1, &Ehelp, &Phelp }
//ChtCmd cc recmd  -pof
