// WSYNC
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	Ulong	unsigned
#define	Ushort	unsigned short
#define	Uchar	unsigned char

#define	MATCH	25

/* File attribute bits in directory entry */
#define	READONLY	0x01	/* File cannot be written */
//#define	HIDDEN		0x02	/* File skipped in normal searches */
#define	SYSTEM		0x04	/* File is considered part of system */
//#define	VOLUME		0x08	/* Directory entry is volume label */
#define DIRECTORY	0x10	/* File is a directory */
//#define	ARCHIVE		0x20	/* File has been modified */

#define	O_OSCOPY	0x01
#define	O_FYES		0x02
#define	O_DYES		0x04
#define	O_ALL		0x40
#define	O_TEST		0x80

Ulong
	TL1, TL2,				// Temp longs (size, time)
	Pd, Pf, Pp, Pe,			// Pool locations
	POOL = (1024*1024),		// Pool size
	Ptop,					// Top of string pool
	FFh;					// FindFile handle
FILE
	*fp,
	*Lfp;
Ushort
	Line,
	Mtop,
	TS1,					// Tep short
	Tdiff = 5,				// Time difference allowed
	Fcount,					// Count of file entries in dir
	TFc, TFe, TFd,
	TDc, TDe, TDd;
Uchar
	*Ptr,					// Generak pointer
	*Pptr,					// Pool name pointer
//	*Pattern,
	*Match[MATCH],
	*Pool,					// Memory pool
	Gc,
	Cars,					// Command AutoResponse
	DoLog,					// Write LOG file
	Soffset,				// Source dir offset
	Doffset,				// Dest dir offset
	Stop,					// Source dir top
	Opt,					// Command options
	Sopt,
	Home[256],
	Lcd[256],				// Last CD directory
	Src[256],				// Source directory/file
	Dst[256],				// Destination directory/file
	Temp[256];				// Temp location

struct	_finddata_t
	FFd;					// FindFile data

Uchar	Mdays[] = {
//	Jan	Feb	Mar	Apr	May	Jun Jul	Aug	Sep	Oct	Nov	Dec
	1,	1,	1,	0,	1,	0,	1,	1,	0,	1,	0,	1 };

#include "R:\\Help.h"

// Format to string routine, format operands are passed
// as a pointer to the calling functions argument lists.
unsigned _format_(char *outptr, unsigned *aptr)
{
	unsigned width, value, i;
	char left, zero, minus, c, *iptr, *optr, *ptr, outstk[11];

	iptr = (char*)*aptr;				// Get input string
	optr = outptr;						// So we can return length
	while(c = *iptr++) {
		if(c == '%') {					// format code
			c = *iptr++;
			*(ptr = &outstk[10]) = left = minus = width = value = i = 0;
			zero = ' ';					// Assume pad with ' '
			if(c == '-') {				// left justify
				left = 255;
				c = *iptr++; }
			if(c == '0')				// pad with '0'
				zero = '0';
			while((c >= '0') && (c <= '9')) {	// Field width
				width = (width * 10) + (c - '0');
				c = *iptr++; }

			value = *++aptr;

			switch(c) {
				case 'd' :				// decimal (signed)
					if(value > 32767) {
						value = 0 - value;
						++minus; }
				case 'u' :				// unsigned
					i = 10;
					break;
				case 'x' :				// hexidecimal
					i = 16;
					break;
				case 'o' :				// octal
					i = 8;
					break;
				case 'c' :				// character
					*--ptr = value;
					break;
				case 's' :				// string
					ptr = (char*)value;
					break;
				default:				// all others
					--aptr;
					*--ptr = c; }

			if(i)		// for all numbers, generate the ASCII string
				do {
					if((c = (value % i) + '0') > '9')
						c += 7;
					*--ptr = c; }
				while(value /= i);

			if(minus) {					// output sign if any
				*optr++ = '-';
				if(width)
					--width; }

			if(width && !left) {		// pad if right justify enabled
				for(i = strlen(ptr); i < width; ++i)
					*optr++ = zero; }

			i = 0;						// move in data
			value = width - 1;
			while((*ptr) && (i <= value)) {
				*optr++ = *ptr++;
				++i; }

			if(width && left) {			// pad if left justify enabled
				while(i < width) {
					*optr++ = zero;
					++i; } } }
		else				// not a format code, simply copy the character
			*optr++ = c; }

	*optr = 0;
	return optr - outptr;
}

void Lpc(Uchar c)
{
	if(Lfp && DoLog)
		putc(c, Lfp);
}
void Pc(Uchar c)
{
	putc(c, stdout);
	Lpc(c);
}
void Ps(Uchar *s)
{
	while(*s)
		Pc(*s++);
}
void Nl(void)
{
	Pc('\n');
}
// Formated print
unsigned Printf(char *format, ...)
{
	unsigned l;
	char buf[128];
	l = _format_(buf, (unsigned*)&format);
	Ps(buf);
	return l;
}
// Convert character to upper case
int Toupper(int c)
{
	if((c >= 'a') && (c <= 'z')) c &= 0x5F;
	return c;
}
void Strupr(Uchar *p)
{
	Uchar c;
	while(c = *p)
		*p++ = Toupper(c);
}

Ushort GetKey(Uchar *ac)
{
	unsigned i;
	unsigned char c;
	for(;;) {
		if( (Gc = toupper(getch())) == 0x1B) {
			Ps("?abort");
			exit(-1); }
		i = 0;
		while(c = ac[i++]) {
			if(c == Gc) {
				Pc(c);
				Nl();
				return i-1; } } }
}

Uchar Msg(Uchar *pre, Uchar *ac, Uchar *buf)
{
	Uchar i, j, c;
	if(pre) {
		Ps(pre);
		Ps("\n "); }
	while(c = *buf++) {
		if(c == '~') {
			Lpc('\n');
			DoLog = 0;
			continue; }
		Pc(c); }
	i = j = 0;
	if(!ac)
		goto a3;
	if(Opt & Cars) {
		Ps(" Yes\n");
		goto a3; }
a1:	while(c = ac[i]) {
		if(c > ' ') {
			Ps(j++ ? "/" : " (");
			Pc(c); }
		++i; }
	if(j) Ps(")?");
a2:	i = GetKey(ac);
	Debug(("[%u]", i))
//	if(i == 2) {	// All
//		Opt |= O_ALL;
//		i = 0; }
a3:	Debug(("[Msg%u]", i))
	return i;
}

// Print and terminate
unsigned CD(unsigned char *dst, unsigned char e);
void Error(char *format, ...)
{
	Uchar buf[128];
	_format_(buf, (unsigned*)&format);
	if(Line) Printf("%u: ", Line);
	Ps(buf);
	CD(Home, 0);
	exit(-1);
}

// Get unsigned from pointer
Ulong Atou(void)
{
	Uchar i, c;
	TL1 = i = 0;
	while((c = Ptr[i] - '0') < 10) {
		TL1 = (TL1 * 10) + c;
		++i; }
	if(c)
		Error("Bad digit");
	return TL1;
}

void Sflg(Ushort x)
{
	Uchar m;
	m = 1 << (x & 7);
	Pool[(x >> 3) + Ptop] |= m;
}
Uchar Tflg(Ushort x)
{
	Uchar m;
	m = 1 << (x & 7);
	return Pool[(x >> 3) + Ptop] & m;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
		if(Toupper(*name++) != Toupper(c))
			return 0; }
}

// Add a string to the pool
Uchar *Pstring(unsigned char *p)
{
	Ulong t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pov1"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}
void Padd(Uchar *d, Uchar l)
{
	do {
		if(Ptop >= POOL)
			Error("?Pov2");
		Pool[Ptop++] = *d++; }
	while(--l);
}
Ulong Pget(Ulong o, Uchar *d, Uchar l)
{
	do {
		*d++ = Pool[o++]; }
	while(--l);
	return o;
}

void PRtime(Ulong t)
{
	Ulong i, j, s;
	Uchar lp;

	t -= 18000;

	j = 1970;
a2:	s = (60*60*24)*365;
	lp = 0;
	if(j % 4)	goto cy;		// Not divisible by 4
	if(j % 100)	goto ly;		// Not divisibke by 100
	if(j % 400)	goto cy;		// Not divisible by 400
ly:	s += (60*60*24);	// Extra day
	lp = 7;
cy:	if(s < t) {
		t -= s;
		++j;
		goto a2; }
	Printf("%u/", j);	//?
	j = 0;
a3:	if(j == 1)	// Feb
		s = lp ? (60*60*24*29) : (60*60*24*28);
	else
		s = Mdays[j] ? (60*60*24*31) : (60*60*24*30);
	if(s < t) {
		t -= s;
		++j;
		goto a3; }
	Printf("%02u/", j+1);
	j = 0;
a4:	s = (60*60*24);
	if(s < t) {
		t -= s;
		++j;
		goto a4; }
	Printf("%02u ", j+1);
	i = j = 0;
a5:	s = (60*60);
	if(s < t) {
		t -= s;
		++j;
		goto a5; }
	Printf(" %02u:%02u:%02u", j, t / 60,  t % 60);
}

//struct _finddata_t {
//    unsigned	attrib;
//    unsigned long	time_create;	/* -1 for FAT file systems */
//    unsigned long	time_access;	/* -1 for FAT file systems */
//    unsigned long	time_write;
//    unsigned long	size;
//    char	name[260]; };

Ushort CKterm(Uchar *p)
{
	Ushort i;
	i = 0; while(p[i]) ++i;
	switch(p[i-1]) {
	default	:
		p[i++] = '\\';
		p[i] = 0;
	case ':':
	case'\\':	; }
	return i;
}

// Test for wildcard characters
Uchar wild(Uchar *p)
{
a1:	switch(*p++) {
	case '*':
	case '?':	return 255;
	default	:	goto a1;
	case 0	:	; }
	return 0;
}

// Test for valid directory
Uchar ISdir(void)
{
	if(FFd.attrib & SYSTEM)	return 0;
	if(FFd.attrib & DIRECTORY) {
		Ptr = FFd.name;
		if(Ptr[0] == '.') switch(Ptr[1]) {
			case '.':	if(Ptr[2]) break;
			case 0	:	return 0; }
		return 0xF0; }
	return 0x0F;
}

Uchar GetN(void)
{
	Uchar c;
	if(Pp < Pe) {
		c = 0xF0;
		if(Pp >= Pf) {
			Pp = Pget(Pp, &TL1, 4);		//size
			Pp = Pget(Pp, &TL2, 4);
			c = 0x0F; }
		Pptr = Pool+Pp;
		while(Pool[Pp++]);
		return c; }
	return 0;
}

// Write string to temp
void Ts(Uchar *p)
{
	while(*p)
		Temp[TS1++] = *p++;
}

// Case InSensive string compare
Uchar CIScmp(Uchar *s1, Uchar *s2)
{
	Uchar c;
	do {
		c = Toupper(*s1++);
		if(Toupper(*s2++) != c)
			return 255; }
	while(c);
	return 0;
}

// Get file directory
Ushort Fdir(Uchar *fn)
{
	Ushort i, j;
	i = j = 0;
a1: switch(fn[i++]) {
	case ':':
	case'\\':	j = i;
	default	:	goto a1;
	case 0	:	;	}
	return j;
}

unsigned CD(unsigned char *dst, unsigned char e)
{
	unsigned char tmp[128];
	if(CIScmp(dst, Lcd)) {
		strcpy(Lcd, dst);
		_chdir(Lcd);
		_getcwd(tmp, sizeof(tmp)-1);
		if(CIScmp(tmp, Lcd)) {
			Ps("?CD'"); Ps(Lcd); Ps("'fail!\n");
			if(e) exit(-1);
			return 7; } }
	return 0;
}

// Change to directory
Uchar Copy(Uchar *dst, Uchar *src)
{
	Ushort i, j;
	Uchar c;

Ps("copy '");
Ps(src);
Ps("'>'");
Ps(dst);
	++TFe;
	if(Opt & O_TEST) {
		Ps("'!\n");
		return; }

	Pc('\'');
	if(!(j = Fdir(dst)))
		Error("?cd");
	c = dst[--j];
	dst[j] = 0;
	CD(Dst, 7);
	dst[j] = c;
	TS1 = 0;
	Ts("copy \"");
	Ts(src);
	Ts("\"");
//	if(!(Opt & O_OSCOPY))
//		Ts(" >NUL");
	Temp[TS1] = 0;
//Pc('>'); Ps(Temp); Nl();
	system(Temp);
	++TFd;
	CD(Home, 7);
}

void Delete(unsigned char *n)
{
	Ps("delete '");
	Ps(n);
	if(Opt & O_TEST) {
		Ps("'!\n");
		return; }
	Ps("'!\n");
	remove(n);
}

Uchar Xmatch(Uchar *n, Uchar *py)
{
	Ushort i;
	Uchar r, *p;
	if(Mtop) {
		i = 0;
		r = 255;
		while(i < Mtop) {
			p = Match[i++];
			if(*p == *py) {		// Yes
				r = 0;
				if(Fmatch(n, p+1))
					goto ry;
				continue; }
			if(*p == py[1]) {	// No
				if(Fmatch(n, p+1))
					return 0; } }
		return r; }
ry:	return 255;
}

void CKfiles(void)
{
	Ushort i;
	Uchar c, d, dt;

	strcpy(Dst+Doffset, Src+Soffset);
	dt = (Stop-Soffset)+Doffset;

	c = Dst[dt-1];
	Dst[dt-1] = 0;
	FFh = _findfirst(Dst, &FFd);
	if(FFh == -1) {
		DoLog = 255;
		Msg(Dst, 0, "NOT found~!");
		goto a1; }
	if(ISdir() != 0xF0) {
		_findclose(FFh);	//?
		DoLog = 255;
		Cars = 0;
		Msg(Dst, " ", "Is NOT a directory~!");
a1:		Dst[dt-1] = 0;
		return; }
	Dst[dt-1] = c;
	_findclose(FFh);	//?

	FFh = _findfirst(Dst, &FFd);
	if(FFh == -1) {
		DoLog = 255;
		Cars = O_FYES;
		if(!Msg(Dst, "YN", "NOT found~! - CopyAll")) {
			Copy(Dst, Src); }
		return; }
	do {
		if(c = ISdir()) {
			if(!Xmatch(Ptr, (c & 0xF0) ? "\\/" : "+-"))
				continue;
			Pp = Pd; i = 0;
			while(d = GetN()) {
				if(!CIScmp(Pptr, Ptr))
					goto b1;
				++i; }
			strcpy(Src+Stop, Ptr);
			strcpy(Dst+dt, Ptr);
			DoLog = 255;
			Cars = 0;
			switch(Msg(Dst, "NSD", "Does NOT exist in source~! - None/ToSrc/Del")) {
			case 1	:
				strcpy(Dst+dt, Ptr);
				Copy(Src, Dst);
				break;
			case 2	:
				strcpy(Dst+dt, Ptr);
				Delete(Dst); }
			continue;
b1:			Sflg(i);	// Mark as used
			if(FFd.attrib & DIRECTORY)
				continue;
			c = 0;
			if((TL2+Tdiff) < FFd.time_write)
				c = '<';
			else if((FFd.time_write+Tdiff) < TL2)
				c = '>';
			if((FFd.size != TL1) || c) {
				strcpy(Src+Stop, Ptr);
				strcpy(Dst+dt, Ptr);
				DoLog = 255;
				PRtime(TL2);
				Printf(" %-10u", TL1);
				Ps(Src); Nl();
				PRtime(FFd.time_write);
				Printf(" %-10u", FFd.size);
				Ps(Dst); Nl();
				if(FFd.size != TL1) Ps(" size");
				if(c) {
					Printf(" %ctime", c);
					if(c == '<') {
						Nl();
						continue; } }
				Cars = O_FYES|O_ALL;
				Pc(' ');
				switch(Msg(0, "YNA", "~Copy")) {
				case 2	:	Opt |= Cars;
				case 0	:	Copy(Dst, Src); } }
			continue; }
	} while(!_findnext(FFh, &FFd));
	_findclose(FFh);
	Opt = Sopt;

	Pp = Pd; i = 0;
	while(c = GetN()) {
		if(Tflg(i++))
			continue;
		strcpy(Src+Stop, Pptr);
		strcpy(Dst+dt, Pptr);
		DoLog = 255;
		if(c & 0xF0) {
			++TDe;
			Cars = O_DYES;
			if(!Msg(Src, "YN", "Does NOT exist in destination~! - Create")) {
				Ps("Create: ");
				Ps(Dst);
				Nl();
				if(!(Opt & O_TEST)) {
					if(_mkdir(Dst))
						Ps("Unable to create!\n");
					++TDd; } }
			continue; }
		Cars = O_FYES|O_ALL;
		switch(Msg(Src, "YNA", "Does NOT exist in destination~! - Copy")) {
		case 2	:	Opt |= Cars;
		case 0	:	Copy(Dst, Src); } }
	Opt = Sopt;
}

void dodir(void)
{
	Ulong pt, pe1, pe2, pp;
	Uchar dt;

//Pc('+'); Ps(Src); Nl();
	pt = Ptop;
//Printf("T%u\n", Ptop);
	dt = Stop;
	strcpy(Src+Stop, "*.*");

	// Record directories
	Fcount = 0;
	FFh = _findfirst(Src, &FFd);
	if(FFh == -1) {
//Ps(Src); exit(-1);
		Printf("?Ffirst\n");
		Stop = dt;
		return; }
	do {
		if(ISdir() & 0xF0) {
			if(Xmatch(Ptr, "\\/")) {
				Pstring(Ptr);
				++Fcount;
				++TDc; } }
	} while(!_findnext(FFh, &FFd));
	pe1 = Ptop;
	_findclose(FFh);

	// Record files
	FFh = _findfirst(Src, &FFd);
	if(FFh == -1)
		Error("?2ndFF");
	do {
		if(FFd.attrib & (SYSTEM|DIRECTORY))	continue;
		if(Xmatch(FFd.name, "+-")) {
			Padd(&FFd.size, 4);
			Padd(&FFd.time_write, 4);
			Pstring(FFd.name);
			++Fcount;
			++TFc;
//Printf("%u %u %08x'%s'\n", TFc, FFd.size, FFd.time_write, FFd.name);
	} } while(!_findnext(FFh, &FFd));
	pe2 = Ptop;
	_findclose(FFh);

	// Check this directory
	Pd = pt;
	Pf = pe1;
	Pe = Ptop;
	TS1 = (Fcount + 7)/8;
//Printf("#%u %u", Fcount, TS1); Ps(Src); Nl();
	if((Ptop + TS1) >= POOL)
		Error("?Pov3");
	memset(Pool+Ptop, 0, TS1);
	Opt &= ~O_ALL;
	CKfiles();

	// Recurse into subdirs
	pp = pt;
	pe2 = Stop;
	Ptop = pe1;
	while(pp < pe1) {
		Stop = pe2;
		strcpy(Src+Stop, Pool+pp);
//Pc('-'); Ps(Src); Nl();
		while(Src[Stop]) ++Stop;
		Src[Stop++] = '\\';
		while(Pool[pp++]);
		dodir(); }

	Stop = dt;
	Ptop = pt;
}

FILE *Fopen(Uchar *fn, Uchar *op)
{
	FILE	*fp;
	if(!(fp = fopen(fn, op))) {
		Ps("Can't open: '");
		Ps(fn);
		Error("'\n"); }
	return fp;
}

void finddir(Uchar *dir, Uchar cr)
{
a1:	if(_chdir(Ptr)) {
		Ps("Cannot access: ");
		Ps(Ptr);
		if(cr && !Msg(0, "YN", "\nCreate")) {
			cr = 0;
			if(!_mkdir(Ptr))
				goto a1;
			Ps("mkdir failed!\n"); }
		exit(-1); }
	_getcwd(dir, 255);
	strcpy(Lcd, dir);
	CD(Home, 7);
}

Uchar CmdArg(Uchar x)
{
	Uchar c;

	Debug(("Arg'%s'\n", Ptr))
	switch(c = Toupper(*Ptr)) {
/*ChtTxt R:\Help
use:	WSYNC source [dest] [options]

opts:	-Alabel		- include Argument section
		-D			- auto create missing Directories		\
		-F			- auto copy changed Files				 > may be stacked
		-O			- display Os 'copy' command output		 > on a single '-'
		-R			- dryRun : don't actually copy files	/
		-Cn			- directory Cache size (nK of memory)			[1024]
			Very large directory trees may cause WSYNC to exhaust its
			1m (1024k) cache.  Use this to allocate a larger cache.
		-L[+]file	- Log differences to text file (+=append)
		-Tn			- allow Time to be behind by n seconds			[5]
		-+pattern	- only process files matching pattern			[*]
		--pattern	- don't process files matching pattern
		-\pattern	- only decend into subdirs matching pattern		[*]
		-/pattern	- don't decend into subdirs matching pattern
			'.' has no special meaning: '*'=all files, '*.*'=must have '.'
	If multiple patterns, they are matched in the order they occur in the
	command, eg: 	--AB* -+A*		will process 'A*' and NOT 'AB*'
					-+A* --AB*		'A*' takes precedence (all files)
'synchronizes' a copy of a directory tree to contain any changed files.
Only new/changed files are copied.

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
	case '-':
	case '/':	++Ptr;
a1:		switch(c=Toupper(*Ptr++)) {
		case 'A':
			if(x) {
				strcpy(Temp+210, Ptr);
				x = 0;
				goto rz; }
		default	:	goto he;
		case 'O':	c = O_OSCOPY;	goto a2;
		case 'R':	c = O_TEST;		goto a2;
		case 'F':	c = O_FYES;		goto a2;
		case 'D':	c = O_DYES;
a2:			Opt |= c;
			if(*Ptr) goto a1;
			goto rz;
		case '+':	// FileYes
		case '-':	// FileNo
		case'\\':	// DirYes
		case '/':	// DirNo
			if(Mtop >= MATCH)
				Error("?>25 patterns");
			if(!*Ptr)
				goto he;
			Match[Mtop++] = Ptr-1;
			goto rz;
		case 'C':	POOL = Atou() * 10;	goto rz;
		case 'T':	Tdiff = Atou();		goto rz;
		case 'L':
			if((c = *Ptr) == '+')
				++Ptr;
			Lfp = Fopen(Ptr, (c=='+')?"a":"w"); }
		case 0	:	goto rz; }

	if(!*Src) {
Debug(("[1]\n"))
		finddir(Src, 0);
		goto rz; }
	if(*Dst) {
he:		return 255; }
Debug(("[2]\n"))
	finddir(Dst, 255);
rz:	return 0;
}

Uchar Skip(void)
{
a1:	switch(*Ptr) {
	case ' ':
	case'\t': ++Ptr; goto a1; }
	return *Ptr;
}
void Trim(void)
{
	Ushort i;
	i = 0;
	while(Ptr[i]) ++i;
a1:	if(i) switch(Ptr[i-1]) {
	case ' ':
	case'\t':
	case'\n':	--i;	goto a1; }
	Ptr[i] = 0;
}

main(int argc, char *argv[])
{
	Ushort i;
	Uchar c, d;

//strcpy(Src, "C:\\dosbox\\C\\src");
//strcpy(Dst, "R:\\dst");

	_getcwd(Home, sizeof(Temp)-1);
	Debug(("H'%s'\n", Home))
//	chdir("WEB"); system("cd"); chdir(Home); system("cd"); //return;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		if(CmdArg(255))
			goto he; }


	if(Temp[210]) {
		Strupr(Temp+210);
		strcpy(Temp, argv[0]);
		if(!(i = Fdir(Temp)))
			Error("?Can'tFindLaunch");
		strcpy(Temp+i, "WSYNC.INI");
		fp = Fopen(Temp, "r");
		c = 255;
		d = 0;
		while(fgets(Ptr = Temp, 200, fp)) {
			++Line;
			switch(Skip()) {
			case ';':
			case 0	:	continue;
			case ':':	++Ptr;
				Skip(); Trim();
				Strupr(Ptr);
				Debug(("?'%s'%s'\n", Temp+210, Ptr))
				c = 0;
				if(!strcmp(Temp+210, Ptr))
					c = d = 255;
				continue; }
			if(c) {
				Trim();
				if(CmdArg(0))
					goto he; } }
		fclose(fp); Line = 0;
		if(!d) Error("Ini'%s'notFound!", Temp+210);
		return; }
	Sopt = Opt;
	if(!*Src) {
he:		Ptr = Help;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		return; }

	if(!*Dst)
		strcpy(Dst, Home);
	if(POOL < 1024)
		Error("?pool");
	Soffset = Stop = CKterm(Src);
	Doffset = CKterm(Dst);

#if 0
	Printf("S'%s'\n", Src);
	Printf("D'%s'\n", Dst);
	Printf("Pool:%u Tdiff:%u", POOL, Tdiff);
//	return;
#endif

	if(!(Pool = malloc(POOL)))
		Error("?malloc");

//	strcpy(Src, "C:\\dosbox\\C\\src");
//	Soffset = Stop = CKterm(Src);
//	strcpy(Dst, "R:\\dst");
//	Doffset = /*Dtop =*/ CKterm(Dst);

	CD(Home, 7);

	dodir();
	DoLog = 255;
	Printf("Dirs : %u/%u/%u\n", TDc, TDe, TDd);
	Printf("Files: %u/%u/%u\n", TFc, TFe, TFd);
	if(Lfp)
		fclose(Lfp);
}	
