/*
 * Skeletal translate() function for Assembly Translator (AT)
 *
 * This function is called to provide the opportunity to process
 * the variable (expression) strings which are extracted from the
 * source operands, and inserted into the output operands ($0...).
 *
 * If the source and output assembly language have the same expression
 * syntax, this function need do nothing, just return the orignal
 * pointer. If you need to process the string, you must copy/process
 * it into a static buffer and return a pointer to that buffer.
 *
 * If you need to know the Instruction and/or operand class that
 * is being processed, you can use the passed Lindex (lookup_index)
 * operand to extract this information from the global Slookup[]
 * table. This will give you a 16 bit unsigned quantity, the high
 * byte contains the instruction number, and the low byte contains
 * the operand classification number (See comments for the variables
 * Sinstructions[] and Soperands[] in the compiled tables file
 * respectively). An Lindex value of -1 (65535) indicates that this
 * instruction/operand did not classify, and is being passed through
 * unchanged to the output file.
 *
 * If you need to know "which" expression from the argument is being
 * processed, this information is passed in the Oindex argument...
 * (0=First-expression, 1=Second expression ...)
 *
 * This is an external function for AT - DO NOT COMPILE TO EXE
 *
 * Compile to a module with DDS Micro-C/PC: CC ATT -FMOP
 * Then link with AT + <table> modules: LC -s AT ATT <table>
 */
#ifdef DEBUG
	#include <stdio.h>		/* For printf() */
#endif

extern unsigned Slookup[];

char *translate(char *p, unsigned Lindex, unsigned Oindex)
{
	#ifdef DEBUG
		printf("translate(%s): Lindex=%u", p, Lindex);
		if(Lindex != -1) {
			printf(" Inst_type=%u", Slookup[Lindex] >> 8);
			printf(" Oper_class=%u", Slookup[Lindex] & 255); }
		printf(" Oindex=%u\n", Oindex);
	#endif

	return p;
}
