;
; Simple "count" program for the 8080 processor.
; Begins at 0000 and counts up to 0FFF.
;
; This program can be converted to an 8086 program with AT8086 and
; then run on a PC under DOS :
;	at8086 COUNT80.ASM of=COUNT86.ASM ld=:	<= Translate to 8086
;	asm86 COUNT86 -t C=COUNT86.COM		<= Assemle to HEX format
;	hexfmt COUNT86.COM -bt			<= Convert to binary image
;
	ORG	$100		; Starting address for program
;
	LXI	H,0		; Begin with zero
loop:	CALL	hl_hex		; Display HL in hex
	MVI	A,$0A		; Line-feed
	CALL	a_out		; Output to console
	MVI	A,$0D		; Carriage return
	CALL	a_out		; Output to console
	INX	H		; Advance to next
	MOV	A,H		; Get high value
	CPI	$10		; Are we at $1000 ?
	JC	loop		; No keep going.
	RET
;
; Display the WORD value in HL as HEX
;
hl_hex:	MOV	A,H		; Get high value
	CALL	a_hex		; Display A in hex
	MOV	A,L		; Get low value
;
; Display the BYTE value in A as HEX
;
a_hex:	PUSH	PSW		; Save A
	RRC			; Move high
	RRC			; digit
	RRC			; Into
	RRC			; Low digit
	CALL	a_nib		; Output nibble
	POP	PSW		; Restore low digit
;
; Display nibble in A as a single HEX digit
;
a_nib:	ANI	%00001111	; Mask off high nibble
	ADI	'0'		; Convert to printable ASCII
	CPI	'9'+1		; Test for alphabetic
	JC	a_out		; No, output it
	ADI	7		; Adjust for alphabetics
;
; Display the character in A on the console
;
; NOTE: This function is designed to work only when translated to
; 8086 code and run on a PC compatible system. It uses "DB" statements
; To generate 8086 instructions which call the BIOS output function.
; To run this program on a real 8085, you would need to supply your
; own "a_out" functions which works with the 8085 hardware platform.
;
a_out:	PUSH	H		; Save HL (BX)
	LXI	H,$0007		; Set fgnd/bgnd (BX)
	DB	$B4,$0E		; 8086 "MOV AH,$0E"
	DB	$CD,$10		; 8086 "INT $10"
	POP	H		; Restore HL (BX)
	RET
