/*
 * Cross reference utility for assembly source files
 *
 * ?COPY.TXT 1983-2005 Dave Dunfield
 * **See COPY.TXT**.
 */
#include <stdio.h>
#include <ctype.h>

#include "xasm.h"

#define	SYMBOLS	2000	/* Maximum number of symbols */
#define	SYMPOOL	20000	/* Space to reserve for them */
#define	SYMSIZE	24		/* Maximum size of a symbol */
#define	SYMDISP	12		/* Size for small symbol display */

#define TAB_SIZE	4

char *symtab[SYMBOLS], sympool[SYMPOOL], *symtop;
char buffer[128], label[SYMSIZE+1], instruction[10], operand[80];
char quiet = 0, prefix=0;

unsigned scount = 0, lcount = 0, width = 80;
unsigned index[SYMBOLS], lines[SYMBOLS*5];

/*
 * Main program
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned i, j, k;
	FILE *fp;
	char *ptr, *ptr1, symbol[80];

	if(argc < 2)
		abort("\nUse: cref <filename> d=symbol* p=char -q w=value >outputfile\n\n?COPY.TXT 1983-2005 Dave Dunfield\n**See COPY.TXT**.\n");

	for(i=2; i < argc; ++i) {
		ptr = ptr1 = argv[i];
		while(*ptr1) {
			*ptr1 = toupper(*ptr1);
			++ptr1; }
		 switch((*ptr++ <<8) + *ptr++) {
			case 'Q-' :				/* quiet option */
				--quiet;
				break;
			case '=W' :
				width = get_num(ptr);
				break;
			case '=D' :
				if(*ptr)
					define_symbol(ptr, 0);
				break;
			case '=P' :
				prefix = *ptr;
				break;
			default:
				abort("Invalid option\n"); } }

	if(!(fp = fopen(argv[1], "r"))) {
		fprintf(stderr,"Unable to open: '%s'\n", argv[1]);
		exit(-1); }

	symtop = sympool;
	if(!quiet)
		fprintf(stderr,"First pass... ");

/* first pass, locate the symbols */
	lcount = 0;
	while(readline(fp)) {
		if(*label && (*label != prefix))
			define_symbol(label, lcount);
		if(!strcmp(instruction, "END"))
			break; }
	rewind(fp);
	index[scount] = scount;

	if(!quiet)
		fprintf(stderr,"Second pass... ");

/* second pass, remember all the references */
	lcount = 0;
	while(readline(fp)) {
		if(!strcmp(instruction, "END"))
			break;
		ptr = operand;
		if((*ptr != '"') && (*ptr != '/')) do {		/* not string operand */
			while(*ptr && !tstalpha(*ptr))
				if(*ptr++ == 0x27)					/* single quote */
					while(*ptr)
						if(*ptr++ == 0x27)
							break;
			if(*ptr) {								/* symbol starting */
				ptr1 = symbol;
				while(*ptr && tstsymbol(*ptr))
					*ptr1++ = *ptr++;
				*ptr1 = 0;
				write_symbol(symbol); } }
		while(*ptr); }
	fclose(fp);

	printf("Cross reference listing of '%s'\n\n", argv[1]);

	printf("  Symbol   Define       References\n");
	printf("---------- ------ ----------------------\n");

	for(lcount=0; lcount < scount; ++lcount) {
		for(i=0; !*symtab[i]; ++i);
		for(j = i+1; j < scount; ++j)
			if(*symtab[j] && (strcmp(symtab[i], symtab[j]) > 0))
				i = j;
		if(strlen(ptr = symtab[i]) >= SYMDISP)
			printf("%s\n   ^   ^   ^", ptr);
		else
			printf("%-12s", ptr);
		*ptr = 0;
		k = SYMDISP;
		for(j = index[i++]; j < index[i]; ++j) {
			if((k += 6) >= width) {
				printf("\n%18s","");
				k = SYMDISP+12; }
			printf("%5u ", lines[j]); }
		putc('\n', stdout); }

	printf("\nSymbols: %u, References: %u\n", scount, index[scount] - scount);
	
	if(!quiet)
		fprintf(stderr,"Done.\n");
}

/*
 * Read a line from the file & split it up into fields
 */
readline(fp)
	FILE *fp;
{
	unsigned count;
	char *ptr, *ptr1, flag;
	count = 0;

	do {
		if(!fgets(buffer, 128, fp))
			return 0;
		++lcount; }
	while((buffer[0] == '*') || (buffer[0] == ';')); /* remove comments */
	ptr = buffer;

	ptr1 = label;							/* get label field */
	while((*ptr != ' ') && (*ptr != 9) && *ptr)
		*ptr1++ = toupper(*ptr++);
	*ptr1 = 0;
	while((*ptr == ' ') || (*ptr == 9))		/* skip blanks */
		++ptr;
	ptr1 = instruction;					/* get instruction field */
	while((*ptr != ' ') && (*ptr != 9) && *ptr)
		*ptr1++ = toupper(*ptr++);
	*ptr1 = 0;
	while((*ptr == ' ') || (*ptr == 9)) {	/* skip blanks */
		if(*ptr == ' ')
			++count;
		else if(*ptr == 9)
			count += TAB_SIZE;
		++ptr; }
	*(ptr1 = operand) = 0;					/* get operand field */
	if((count > 10) || !*ptr)
		return 1;
	flag = count = 0;
	while((flag || ((*ptr != ' ') && (*ptr != 9))) && *ptr) {
		if(*ptr == flag)					/* terminator character */
			flag = 0;
		else if(*ptr == 0x27) {				/* single quote */
			if(!flag) flag = 0x27; }
		else if((*ptr == '"') && !count)	/* begins with double quote */
			flag = '"';
		else if((*ptr == '/') && !count)	/* begins slash delimiter */
			flag = '/';
		*ptr1++ = toupper(*ptr++);
		++count; }
	*ptr1 = 0;
	return 1;
}

/*
 * copy a string
 */
scopy(dest, source)
	char *dest, *source;
{
	do
		*dest++ = *source;
	while(*source++);
}

/*
 * compare strings, return 1 if equal
 */
sequal(str1, str2)
	char *str1, *str2;
{
	do
		if(*str1++ != *str2)
			return 0;
	while(*str2++);
	return 1;
}

/*
 * test for alpha characters
 */
tstalpha(chr)
	char chr;
{
	if((chr >= 'A') && (chr <= 'Z'))
		return 1;
	if((chr >= 'a') && (chr <= 'z'))
		return 1;
	return 0;
}

/*
 * test for a valid symbol character
 */
tstsymbol(chr)
	char chr;
{
	if((chr >= 'A') && (chr <= 'Z'))
		return 1;
	if((chr >= 'a') && (chr <= 'z'))
		return 1;
	if((chr >= '0') && (chr <= '9'))
		return 1;
	return 0;
}

/*
 * Define a symbol
 */
define_symbol(symbol, value)
	char *symbol;
	unsigned value;
{
	if(scount < SYMBOLS) {
		lines[index[scount] = scount] = value;
		symtab[scount++] = symtop;
		while(*symtop++ = *symbol++);
		if(*(symtop-2) == ':')
			*(symtop-2) = 0;
		if((symtop - sympool) <= sizeof(sympool))
			return; }

	xabort("symbol");
	abort("Symbol table overflow\n");
}

/*
 * Write a sumbol to the output file
 */
write_symbol(string)
	char *string;
{
	unsigned i, j, k;

	for(i = 0; i < scount; ++i) {
		if(sequal(string, symtab[i])) {
			for(k = index[j = scount]; j > i; --k) {
					lines[k+1] = lines[k];
					if(index[j] == k)
						++index[j--]; }
			lines[k+1] = lcount;
			return; } }
}

/*
 * Get a number from the input
 */
get_num(string)
	char *string;
{
	unsigned value;
	char chr;
	value = 0;

	if(isdigit(*string))				/* decimal number */
		while(isdigit(chr=*string++))
			value = (value * 10) + chr - '0';
	else if('$'==(chr=*string++))		/* hexidecimal number */
		while((isdigit(chr=toupper(*string++))) || ((chr >= 'A') && (chr <= 'F')))
			value = (value << 4) + ((chr < 'A') ? (chr - '0') : (chr - '7'));
	else if(chr=='@')					/* octal number */
		while(('0'<=(chr=*string++)) && (chr < '8'))
			value = (value << 3) + (chr - '0');
	else if(chr=='%')					/* binary number */
		while(('0'==(chr=*string++)) || (chr=='1'))
			value = (value << 1) + (chr - '0') ;
	else chr=-1;
	if(chr)
		abort("Invalid numeric operand\n");
	return value;
}
