/*
 * Assembly "porting" source code generator
 *
 * ?COPY.TXT 1983-2005 Dave Dunfield
 * **See COPY.TXT**.
 */
#include <stdio.h>
#include <ctype.h>
#include "xasm.h"

#define	SYMBOLS		2000
#define	SYMPOOL		20000
#define TAB_SIZE	4
#define	NUMKEEP		50
#define	SYMSIZE		8

char *symtab[SYMBOLS], sympool[SYMPOOL], *symtop;
char label[SYMSIZE+1], instruction[10], operand[80];
char buffer[128], *outptr, keeptab[NUMKEEP][SYMSIZE+1];
char quiet = 0, space = ' ', pass = 0;
unsigned scount = 0;

main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned i, kcount;
	FILE *fp;
	char *ptr, *ptr1, symbol[80];
	kcount = 0;

	if(argc < 2)
		abort("\nUse: psource <file> [-qt k=label* K=file] >outputfile\n\n?COPY.TXT 1983-2005 Dave Dunfield\n**See COPY.TXT**.\n");

	for(i=2; i < argc; ++i) {
		if(*(ptr = argv[i]) == '-') {		/* Enable switch */
			while(*++ptr) switch(toupper(*ptr)) {
				case 'T' : space = '\t';	break;		/* Use TABS */
				case 'Q' : quiet = -1;		break;		/* Quiet option */
				default: goto badopt; }
			continue; }
		if(*++ptr == '=') switch(*(ptr++ - 1)) {
			case 'k' :				/* a label to keep */
				scopy(keeptab[kcount++], &argv[i][2]);
				continue;
			case 'K' :				/* a file of labels to keep */
				if(!(fp = fopen(ptr = &argv[i][2], "r"))) {
					fprintf(stderr,"Unable to access: '%s'\n", ptr);
					exit(-1); }
				while(fgets(symbol, sizeof(symbol), fp))
					scopy(keeptab[kcount++], symbol);
				fclose(fp);
				continue; }
	badopt:
		fprintf(stderr,"Invalid option: %s\n", argv[i]);
		exit(-1); }

	if(!(fp = fopen(argv[1],"r"))) {
		fprintf(stderr,"Unable to access: '%s'\n", argv[1]);
		exit(-1); }

	if(!quiet)
		fprintf(stderr,"First pass... ");

/* first pass, locate the symbols */
	symtop = sympool;
	while(readline(fp))
		if(label[0]) {
			for(i=0; i < kcount; ++i) {
				if(sequal(label, keeptab[i]))
					break; }
			if(i == kcount) {	/* not a keep symbol, record it */
				if(scount >= SYMBOLS) {
					xabort("symbol");
					abort("Symbol table overflow\n"); }
				ptr = label;
				symtab[scount++] = symtop;
				while(*symtop++ = *ptr++); } }
	rewind(fp);

	if(!quiet)
		fprintf(stderr,"Second pass... ");
	pass = -1;

	while(readline(fp)) {
		outptr = buffer;
		if(label[0])			/* there is a label */
			write_symbol(label);
		*outptr++ = space;		/* separator */
		ptr = instruction;
		while(*ptr)				/* copy instruction */
			*outptr++ = *ptr++;
		*outptr++ = space;		/* separator */
		ptr = operand;
		if((*ptr == '"') || (*ptr == '/'))	/* string operand */
			while(*ptr)
				*outptr++ = *ptr++;
		else do {							/* normal operand */
			while(*ptr && !tstalpha(*ptr))
				if((*outptr++ = *ptr++) == 0x27)	/* single quote */
					while(*ptr)
						if((*outptr++ = *ptr++) == 0x27)
							break;
			if(*ptr) {						/* symbol starting */
				ptr1 = symbol;
				while(*ptr && tstsymbol(*ptr))
					*ptr1++ = *ptr++;
				*ptr1 = 0;
				write_symbol(symbol); } }
			while(*ptr);
		*outptr = 0;
		fprintf(stdout,"%s\n", buffer); }

	if(!quiet)
		fprintf(stderr,"Done.\n");
	fclose(fp);
}

readline(fp)
	FILE *fp;
{
	unsigned count;
	char *ptr, *ptr1, flag;
	count = 0;

	do {
		if(!fgets(buffer, 128, fp))
			return(0);
		if(*buffer == ';') {
			*buffer = '*';
			if(pass) {
				fputs(buffer, stdout);
				putc('\n', stdout); } } }
	while(*buffer == '*'); /* remove comments */
	ptr = buffer;

	ptr1 = label;							/* get label field */
	while((*ptr != ' ') && (*ptr != 9) && *ptr)
		*ptr1++ = *ptr++;
	*ptr1 = 0;
	while((*ptr == ' ') || (*ptr == 9))		/* skip blanks */
		++ptr;
	ptr1 = instruction;					/* get instruction field */
	while((*ptr != ' ') && (*ptr != 9) && *ptr)
		*ptr1++ = *ptr++;
	*ptr1 = 0;
	while((*ptr == ' ') || (*ptr == 9)) {	/* skip blanks */
		if(*ptr == ' ')
			++count;
		else if(*ptr == 9)
			count += TAB_SIZE;
		++ptr; }
	*(ptr1 = operand) = 0;					/* get operand field */
	if((count > 10) || !*ptr)
		return(1);
	flag = count = 0;
	while((flag || ((*ptr != ' ') && (*ptr != 9))) && *ptr) {
		if(*ptr == flag)		/* terminator character */
			flag = 0;
		else if(*ptr == 0x27) {				/* single quote */
			if(!flag) flag = 0x27; }
		else if((*ptr == '"') && !count)	/* begins with double quote */
			flag = '"';
		else if((*ptr == '/') && !count)	/* begins slash delimiter */
			flag = '/';
		*ptr1++ = *ptr++;
		++count; }
	*ptr1 = 0;
	return(1);
}

/* write a sumbol to the output file */
write_symbol(string)
	char *string;
{
	unsigned i, j;
	for(i = 0; i < scount; ++i)
		if(sequal(string, symtab[i]))
			break;
	if(i < scount) {		/* symbol has been recorded */
		j = 3;
		do {
			*outptr++ = (i%26) + 'A';
			i = i / 26;
			--j; }
		while(i || j); }
	else
		while(*string)
			*outptr++ = *string++;
}

/* copy a string */
scopy(dest, source)
	char *dest, *source;
{
	do
		*dest++ = *source;
	while(*source++);
}

/* compare strings, return 1 if equal */
sequal(str1, str2)
	char *str1, *str2;
{
	do
		if(*str1++ != *str2)
			return(0);
	while(*str2++);
	return(1);
}

/* test for alpha characters */
tstalpha(chr)
	char chr;
{
	if((chr >= 'A') && (chr <= 'Z'))
		return(1);
	if((chr >= 'a') && (chr <= 'z'))
		return(1);
	return(0);
}

/* test for a valid symbol character */
tstsymbol(chr)
	char chr;
{
	if((chr >= 'A') && (chr <= 'Z'))
		return(1);
	if((chr >= 'a') && (chr <= 'z'))
		return(1);
	if((chr >= '0') && (chr <= '9'))
		return(1);
	if(chr == '_')
		return(1);
	return(0);
}
