#include c:\mc\stdio.h
/* Constant parameters */
#define	NKEYS	11
#define	KEYLEN	10
#define	NAMLEN	10000
#define	OPRLEN	32500

/* Operand keyvalues */
#define	NONE	0
#define	IMM8	1
#define	IMM16	2
#define	VALUE8	3
#define	VALUE16	4
#define	KEYWORD	5		/* Offset to keywords */

unsigned char keyword[NKEYS][KEYLEN+1], name[NAMLEN], operand[OPRLEN];
int kptr = 0, nptr = 0, optr = 0, line = 0;

unsigned icount = 0, vcount = 0, user_define = 0;

char *ptr, *ptr1, buffer[100], cpu_long[20], cpu_short[10];

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, k, onum, opsave, otype[4];
	char word[50];
	FILE *fp, *fp1, *fp2, *fp3;

	fputs("\nUniversal Assembler Table Compiler v1.1\n", stderr);
	if(argc < 2)
		abort("\nUse: ucomp <table file> [temp prefix]\n\n?COPY.TXT 1993-2005 Dave Dunfield\n -- see COPY.TXT --.\n");

	concat(word, argv[1], ".UAS");
	fp = fopen(word, "rvq");
	ptr = (argc > 2) ? argv[2] : "";
	concat(word, ptr, "UASM.001");
	fp1 = fopen(word, "wvq");
	concat(word, ptr, "UASM.002");
	fp2 = fopen(word, "wvq");
	concat(word, ptr, "UASM.003");
	fp3 = fopen(word, "wvq");
	*name = 0;

	do {
		fgets(ptr = buffer, sizeof(buffer)-1, fp);
		++line; }
	while(*buffer == '*');
	parse(cpu_long);
	parse(cpu_short);

	while(parse(word))
		strcpy(keyword[kptr++], word);

	fprintf(fp1, "/* Global definitions for %s assembler */\n", cpu_long);
	fprintf(fp2, "/* Special instruction handlers for %s assembler pass 1 */\n", cpu_long);
	fprintf(fp3, "/* Special instruction handlers for %s assembler pass 2 */\n", cpu_long);
	fprintf(fp1, "#define CPU_LONG \"%s\"\n", cpu_long);
	fprintf(fp1, "#define CPU_SHORT \"%s\"\n", cpu_short);

	opsave = 0;
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		++line;
		/* Add new names to name table */
		if(!isspace(*buffer)) {
			if((*buffer == '*') || !*buffer)
				continue;
			if(*buffer == '{') {
				while(fgets(buffer, sizeof(buffer)-1, fp)) {
					++line;
					if(*buffer == '}')
						break;
					fputs(buffer, fp1);
					putc('\n', fp1); }
				continue; }
			if(*buffer == '#') {
				fprintf(fp1, "#define %s\n", buffer+1);
				continue; }
			++icount;
			i = 0;
			while(*ptr && !isspace(*ptr))
				word[i++] = toupper(*ptr++);
			word[i] = 0;
			if(lookup_instruction(word))
				error("Duplicate instruction");
			i = 0;
			while(name[nptr] = word[i++])
				++nptr;
			while(isspace(*ptr))
				++ptr;
			if(*ptr == '=') {
				name[nptr++] = -1;
				name[nptr++] = atoi(++ptr);
				continue; }
			if(*ptr == '{') {
				name[nptr++] = -2;
				name[nptr++] = ++user_define;
				fprintf(fp2,"case 0x7E%02x : /* %s */\n", user_define, word);
				fprintf(fp3, "case 0x7E%02x : /* %s */\n", user_define, word);
				if(*(ptr+1) != '}') {
					while(fgets(buffer, sizeof(buffer)-1, fp)) {
						++line;
						if(*buffer == '$')
							break;
						fputs(buffer, fp2);
						putc('\n', fp2); }
					fputs("break;\n", fp2);
					while(fgets(buffer, sizeof(buffer)-1, fp)) {
						++line;
						if(*buffer == '}')
							break;
						fputs(buffer, fp3);
						putc('\n', fp3); }
					fputs("break;\n", fp3); }
				continue; }
			if((optr - 1) == opsave)
				--optr;
			name[nptr++] = (optr >> 8) | 0x80;
			name[nptr++] = optr;
			operand[opsave = optr++] = 0x00; }

		while(isspace(*ptr))	/* Skip to operand field */
			++ptr;
		if(!*ptr)
			continue;

		/* Parse operands and add to table */
		otype[3] = otype[2] = otype[1] = otype[0] = onum = 0;
		++vcount;
		if(*ptr) {
			if(*ptr == '-') {
				++ptr;
				goto noopr; }
		nxtopr:
			ptr1 = word;
			while(*ptr && (*ptr != ',') && !isspace(*ptr))
				*ptr1++ = toupper(*ptr++);
			*ptr1 = 0;
			/* Search for keyword */
			for(i=0; i < kptr; ++i)
				if(!strcmp(keyword[i], word)) {
					i += KEYWORD;
					goto gotopr; }
			/* Get operand type */
			i = 0;
			ptr1 = word;
			if(*ptr1 == '<') {
				i = 1;
				++ptr1; }
			if(*ptr1 == '>') {
				i = 2;
				++ptr1; }
			switch(*ptr1++) {
				case '@' :
					operand[opsave] |= i << 2;
					i = (i == 1) ? VALUE8 : VALUE16;
					break;
				case '#' :
					operand[opsave] |= i;
					i = (i == 1) ? IMM8 : IMM16;
					break;
				case 0 :
					i = NONE;
					break;
				default:
printf("Offending char='%04x'\n", *(ptr1-1));
					error("Invalid operand type"); }
		gotopr:
			if(onum > 3)
				error("Too many operands");
			otype[onum++] = i;
			if(*ptr == ',') {
				++ptr;
				goto nxtopr; } }
	noopr:

		onum = optr++;
		operand[optr++] = (otype[0] << 4) | otype[1];
		operand[optr++] = (otype[2] << 4) | otype[3];

		i = j = 0;
		while((k = get_operand(0)) == 1)
			++i, ++j;
		if(k) do
			++j;
		while(get_operand(&j));

		operand[onum] = 0x80 | (i << 4) | j; }

	fprintf(stderr,"\nName    table used=%-5u of %-5u bytes.\n", nptr, sizeof(name));
	fprintf(stderr,"Operand table used=%-5u of %-5u bytes.\n", optr, sizeof(operand));

/* Dump the keyword table */
	fputs("char *keyword_table[] = { ", fp1);
	for(i=0; i < kptr; ++i)
		fprintf(fp1, "\"%s\", ", keyword[i]);
	fputs("0 };\n\n", fp1);

/* Dump the instruction name table */
	fputs("char name_table[] = {\n", fp1);
		i = 0;
		while(i < nptr) {
			putc('\t', fp1);
			while(!((j = name[i++]) & 0xFF80))
				fprintf(fp1, "'%c', ", j);
			fprintf(fp1, "0x%02x, 0x%02x,\n",  j, name[i++]); }
		fputs("\t0 };\n\n", fp1);

/* Dump the operand table */
	fputs("char operand_table[] = {\n", fp1);
		i = k = 0;
		ptr = word;
		while((j = name[k++]) && !(j & 0x80)) 
			*ptr++ = j;
		*ptr = 0;
		opsave = (j << 8) | name[k++];
	oprout:
		if(!(operand[i] & 0x80)) {
			fprintf(fp1, "\t0x%02x,\t/* ", operand[i++]);
nextname:
			fputs(ptr = word, fp1);
			while((j = name[k++]) && !(j & 0x80)) 
				*ptr++ = j;
			*ptr = 0;
			onum = (j << 8) | name[k++];
			if(onum == opsave) {
				putc(',', fp1);
				goto nextname; }
			opsave = onum;
			fprintf(fp1, " */\n"); }
		fprintf(fp1, "\t0x%02x, 0x%02x, 0x%02x", j = operand[i++], operand[i++], operand[i++]);
		j &= 0x0f;
		while(j--)
			fprintf(fp1, ", 0x%02x", operand[i++]);
		if(i < optr) {
			fputs(",\n", fp1);
			goto oprout; }
	fputs(" };\n\n", fp1);

	fprintf(stderr,"\nCompiled %u instructions with a total of %u operand formats.\n", icount, vcount);
	fclose(fp);
	fclose(fp1);
	fclose(fp2);
	fclose(fp3);
}

/*
 * Get an operand value
 */
get_operand(flag)
	int *flag;
{
	unsigned i, j, b;

	while(isspace(*ptr))
		++ptr;

	if(!*ptr)
		return 0;

	i = 0;
	switch(*ptr++) {
	case '@' : b = 8; goto donum;
	case '%' : b = 2; goto donum; }
	if(isxdigit(*--ptr)) {
		b = 16;
	donum:
		while(*ptr && !isspace(*ptr)) {
			j = toupper(*ptr++);
			if((j >= '0') && (j <= '9'))
				j -= '0';
			else if((j >= 'A') && (j <= 'F'))
				j -= '0' + 7;
			else
				j = b;
			if(j >= b)
				error("Invalid digit");
			i = (i * b) + j; }
		if(flag) {
			operand[optr++] = 0xFF;
			++*flag; }
		operand[optr++] = i;
		return 1; }

	for(;;) switch(j = *ptr++) {
		case '>' :	/* 16 bit */
			i |= 0x40;
			continue;
		case '<' :	/* Low byte */
			i &= ~0x40;
			continue;
		case '^' :	/* Reverse */
			i |= 0x20;
			continue;
		case '$' :	/* PC relatve */
			i |= 0x10;
			continue;
		case '~' :	/* Internal variable */
			if((j = *ptr++ - '1') > 3)
				error("Invalid variable number");
			operand[optr++] = i | j | 0x80;
			return 2;
		default:
			if((j -= '1') > 3)
				error("Invalid argument number");
			operand[optr++] = i | j;
			return 2; }
}

/*
 * Report a compile error
 */
error(text)
	char *text;
{
	fprintf(stderr,"Line %u : %s\n%s", line, text, ptr);
	exit(-1);
}

/*
 * Lookup instruction in table
 */
int lookup_instruction(inst)
	char *inst;
{
	unsigned char *n_ptr, *end;
	unsigned char *ptr;

	end = (n_ptr = name) + nptr;
	do {
		ptr = inst;
		while(*ptr == *n_ptr) {
			++ptr;
			++n_ptr; }
		if((*n_ptr & 0x80) && !*ptr) {
			return -1; }
		while(!(*n_ptr & 0x80))
			++n_ptr;
		n_ptr += 2; }
	while(n_ptr < end);
	return 0;
}

/*
 * Parse date from pointer into buffer
 */
parse(char *p)
{
	while(isspace(*ptr))
		++ptr;
	if(!*ptr)
		return 0;
	while(*ptr && !isspace(*ptr))
		*p++ = toupper(*ptr++);
	*p = 0;
	return -1;
}
