// ZDIR
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	TMPZIP	"_ZDIR_"	// Used during =time update
#define	BWIDTH	78

#define	LIST	16			// Size of pattern list
#define	POOL	8192		// Size of string pool
#define	NDT		0xA5A5		// No =time

#define	O_FIL	0x01		// Show indivial file entries
#define	O_DIR	0x02		// main Dictionary entries
#define	O_FD	0x03		//	both ^^
#define	O_SNO	0x04		// Show Name Only
#define	O_SCS	0x08		// Show Compressed Size
#define	O_ROZ	0x10		// Replace Original Zip
#define	O_VERB	0x20		// More output
#define	O_DBG	0x80

unsigned
	Flag,					// ZIP flags
	FNl, EXl, CMl,			// FileName, EXtra, CoMment Lengths
	Hoff,					// Header offset (based on record type)
	Ltop,					// Top of pattern list
	Ptop,					// "" string pool
	Opos, Owid,
	Ldt[LIST][6],			// List update Date/Times
	ADTcount1, ADTcount2,	// ADjusTment counts
	Page, Page1,			// Output page size
	L10[] = { 10, 0 };		// Long 10 (used by ShowLN()
FILE
	*fpi,
	*fpo;
unsigned char
	*Ptr,					// General pointer
	*List[LIST],			// Pattern-file list
	Opt = O_DIR|O_VERB|O_ROZ, // Command line Options
	Sdt,					// SetDateTime (=yr...)
	Ifile[128],				// Inpout file
	Ofile[128],				// Output file
	Hdr[512],				// Working ZIP header
	Name[128],				// Filename within
	Pool[POOL];				// String storage pool
extern unsigned Longreg[];
//ChtTxt R:\Help.H
#include "R:\\Help.h"

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

// Simple console output
void Pc(unsigned char c)
{
	if(Opt & O_VERB) {
		switch(c) {
		case'\n':	Opos = 0; break;
		default	:	++Opos; }
		putc(c, stdout); }
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Sp(void)				{	Pc(' ');			}
void Nl(void)
{
	if(Page && !--Page1) {
		Ps(" ?");
a1:		switch(kbget()) {
		default	:	goto a1;
		case 0x1b:	Error("");
		case ' ':	Ps("\b\b  \b\b"); }
		Page1 = Page; }
	Pc('\n');
}
register Pr(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

void Wps(unsigned char *s)
{
	unsigned op;
	if(Owid & 0x7FFF) {
		if(op = Opos)
			do ++op; while op % Owid;
		if((strlen(s) + op) >= BWIDTH)
			Nl();
		else {
			while(Opos < op)
				Pc(' '); } }
	Ps(s);
}
void Wnl(void)
{
	if(Opos) Nl();
}

// Debug output
register Dpr(unsigned args)
{
	unsigned n;
	unsigned char buf[200];
	n = nargs();
	if(Opt & O_DBG) {
		_format_(n*2+&args, buf);
		Ps(buf); }
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

// GetTime from command line
void Gtime(unsigned t[6])
{
	unsigned i, c, v;
	unsigned char *p, d, f;
	memset(t, 0xFF, sizeof(t));
	p = Ptr;
	i = d = 0;
a1:	v = f = 0;
a2:	switch(c = *Ptr++) {
	default	:	// Numeric entry
		if((c -= '0') > 9)
			Error("?Value'%s'", p);
		v = (v * 10) + c;
		f = 7;
	case '*':	// Leave unchanged
		goto a2;
	case '/':	// Date
	case '-':	d = 7;	break;
	case ':':	// Time
		if(!d)		i = d = 3;	// if Time first, skip setting date
		if(i < 3)	i = 3;		// If in partial date. leave rest unchanged
	case 0	:	; }				// Last entry
	if(f)	// If a number supplied, set it
		t[i] = v;
	if(c && ++i >= (sizeof(t)/2))	// Too many entries?
		Error("?format'%s'", p);
	if(c) goto a1;				// More to come
	Debug(("%u-%u-%u_%u:%u:%u\n", t[0], t[1], t[2], t[3], t[4], t[5]))
	if(*t < 80)	*t += 2000;	// nn=19nn
}


// Auto-add extension to file name
unsigned Fext(unsigned char fn[], unsigned char *ext)
{
	unsigned i, j, k;
	i = j = 0;
a1:	k = 0;
a2:	switch(fn[i++]) {
	case ':':
	case'\\':	j = i;	goto a1;
	case '.':	k = i;
	default	:			goto a2;
	case 0	:	; }
	if(!k)
		strcpy(fn+i-1, ext);
	return j;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
		if(toupper(*name++) != c)
//		if(*name++ != c)
			return 0; }
}

void ShowDT(unsigned da, unsigned ti)
{
	Pr("%04u-%02u-%02u", (da>>9)+1980,	(da>>5)&15,		da&31);
	Pr("%3u:%02u:%02u ", ti>>11, 		(ti>>5)&63,		(ti&31)*2);
}

void ShowLN(unsigned h, unsigned l)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
	while(i) buf[--i] = ' ';
	Ps(buf);
	Sp();
}

// Read Header word
unsigned Hw(unsigned o)
{
	unsigned i;
	i = Hdr[o+1] << 8;
	return Hdr[o] | i;
}

// Get block from input
void FGet(unsigned char *dst, unsigned siz)
{
	if(fget(dst, siz, fpi) != siz)
		Error("?FGet(%u)", siz);
}

// Write block to output
void FPut(unsigned char *src, unsigned siz)
{
	if(fpo)
		fput(src, siz, fpo);
}

// Ship large block
void Skip(unsigned h, unsigned l)
{
	unsigned i, c;
	if(fpo) { // Updating
		while(l) {
a1:			if( (c = getc(fpi)) == EOF)
				Error("?Skip");
			putc(c, fpo);
			--l; }
		if(h) {
			--h;
			goto a1; }
		return; }
	if(i = fseek(fpi, h, l, 1))
		Error("?Seek(%u)", i);
}

// Adjusts supplied sections of this specific entry
void _adjdt_(unsigned td, unsigned v,
	unsigned a, unsigned s, unsigned l, unsigned h)
{
	unsigned *p;
	p = Hdr+Hoff+td;
	Debug(("%04x[%04x] &%04x %x %u-%u", p, *p, a, v, l, h))
	if(v != -1) {
		if((v < l) || (v > h))	Error("Value%u (%u-%u)", v, l, h);
		if(s & 0x100) v -= 1980;
		if(s & 0x200) v >>= 1;
		*p = (*p & a) | (v << (s & 255)); }
	Debug(("[%04x]\n", *p))
}
// Apply applicable DateTime adjustments
unsigned AdjDT(unsigned i)
{
	unsigned *t;
	t = Ldt[i];
// yyyy yyym mmmd dddd
// 0000 0001 1111 1111		01FF	<<9
// 1111 1110 0001 1111		FE1F	<<5
// 1111 1111 1110 0000		FFE0	<<0
// hhhh hmmm mmms ssss
// 0000 0111 1111 1111		07FF	<<11
// 1111 1000 0001 1111		F81F	<<5
// 1111 1111 1110 0000		FFE0	<<0
	_adjdt_(0x0C, t[0],	0x01FF, 0x109,1980,2107);	// Year
	_adjdt_(0x0C, t[1],	0xFE1F,		5,	1, 12);		// Month
	_adjdt_(0x0C, t[2],	0xFFE0,		0,	1, 31);		// Day
	_adjdt_(0x0A, t[3],	0x07FF,	   11,	0, 24);		// Hour
	_adjdt_(0x0A, t[4],	0xF81F,		5,	0, 60);		// Minite
	_adjdt_(0x0A, t[5],	0xFFE0, 0x200,	0, 60);		// Second
	Debug(("%u-%u-%u %u-%u-%u ", t[0], t[1], t[2], t[3], t[4], t[5]))
	Debug(("%s\n", Name+FNo))
}

// Process each file occuring in .ZIP
unsigned ProcessFile(unsigned char op, unsigned char d)
{
	unsigned i, j, k, r;
	FNl = Hw(Hoff+0x1A);
	EXl = Hw(Hoff+0x1C);
	Debug(("[N%uE%uC%u]", FNl, EXl, CMl))
	FGet(Name, FNl);
	Name[FNl] = i = j = k = r = 0;
a1:	switch(Name[i++]) {
	case ':':
	case '/':
	case'\\':	j = i;
	default	:	goto a1;
	case 0	:	; }
	if(!Name[j])
		goto a3;
	for(i=0; i < Ltop; ++i) {
		if(Fmatch(Name+j, List[i]))
			goto a2; }
	goto a3;
a2:	Debug(("%u[%04x=%04x]", i, *Ldt[i], NDT))
	if(Opt & op) {
		if( ((Opt & O_FD) == O_FD) && !Owid) {
			Pc(d);
			Sp(); }
		if(Opt & O_SNO)
			k = j;
		if(!Owid) {
			ShowDT(Hw(Hoff+0x0C), Hw(Hoff+0x0A));					// Date/Time
			ShowLN(Hw(Hoff+0x18), Hw(Hoff+0x16));					// UncompSize
			if(Opt & O_SCS)	ShowLN(Hw(Hoff+0x14), Hw(Hoff+0x12)); }	// CompSize
		Wps(Name+k); }
	if(*Ldt[i] != NDT) {
		AdjDT(i);
		r = 7;
		if(Opt & op) {
			Ps(" =");
			ShowDT(Hw(Hoff+0x0C), Hw(Hoff+0x0A));
			Wnl();
			return; } }
	if((Opt & op) && !(Owid & 0x7FFF))
		Nl();
a3:	return r;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt Mhelp
ZipDIRectory

use:	ZDIR zipfile[.ZIP] [pattern][=[yr-mo-dy]-[hr:mi:se]]... [options]

Opts:	-B			 Bare (no times/sizes shown)
		-C			 show Compressed size
		-D			 don't show main Directory entries
		-F			 show individual File entries
		-N			 show Names only (no path)
		-Ofile[.ZIP] set Output file			(only if)	 [%TEMP%_ZDIR_.ZIP]
		-R			 don't Replace original ZIP	( =yr...)		(keep ^^)
		-P[n]		 Page [24]lines (press SPACE to proceed, ESC to exit)
		-W[col]]	 Wide (bare in columns [13])
		-Q			 Quiet (no output)
Displays the content of a .ZIP in {directory format}
  pattern = file match pattern (may contain '*','?'):	*=All  *.*=MustHave'.'
shows original DOS timestamps (Windows tries to adjust for DST)

If =yr-mo-dy-hr:mi:se  those values in pattern-file timestamps will be changed
(TOUCHed)	* =skip but don't change.	  If first seperator is ':', only time
is changed (not date).	 Some OSs (Windows) don't accept = (use "pattern=...")

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
			case 'W':
				if(!(Owid = atoi(Ptr)))
					Owid = 13;
				continue;
			case 'O':
				strcpy(Ofile, Ptr);
				Ptr = "";
			case 'B':	Owid = 0x8000;	break;
			case 'P':
				while((c = *Ptr - '0') < 10) {
					Page = (Page * 10) + c;
					++Ptr; }
				if(!Page) Page = 24;
				Page1 = Page;
				continue;
			case 'R':	c = O_ROZ;		goto o2;
			case 'C':	c = O_SCS;		goto o2;
			case 'D':	c = O_DIR;		goto o2;
			case 'F':	c = O_FIL;		goto o2;
			case 'N':	c = O_SNO;		goto o2;
			case 'Q':	c = O_VERB;		goto o2;
			case '_':	c = O_DBG;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!*Ifile) {
			strcpy(Ifile, Ptr);
			strupr(Ifile);
			continue; }
		if(Ltop >= LIST) Error("?#list");
		*Ldt[Ltop] = NDT;
o3:		switch(*Ptr++) {
		default	:	goto o3;
		case '=':	*(Ptr-1) = 0;
			Gtime(Ldt[Ltop]);
			Sdt = 0xA5;
		case 0	:
			strupr(List[Ltop++] = Pstring(argv[i])); } }


	if(!*Ifile) {
he:		Ptr = Mhelp;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return; }

	if(!Ltop) {
		*Ldt[0] = NDT;
		List[Ltop++] = "*"; }

	Fext(Ifile, ".ZIP");
	if(Sdt == 0xA5) {
		if(!*Ofile) {
			getenv("TEMP", Ofile);
			if(i = strlen(Ofile)) {
				if(Ofile[i-1] != '\\')
					Ofile[i++] = '\\'; }
			strcpy(Ofile+i, TMPZIP); }
		Fext(Ofile, ".ZIP"); }

#if 0	// Debug command argsd
	printf("I`%s`%02x`%s`\n", Ifile, Sdt, Ofile);
	for(i=0; i < Ltop; ++i) {
		Pr("%u`%s`%x-%x-%x %x:%x:%x\n", i, List[i],
			Ldt[i][0], Ldt[i][1], Ldt[i][2], Ldt[i][3], Ldt[i][4], Ldt[i][5]); }
	return;
#endif

	fpi			= fopen(Ifile, "rbvq");
	if(Sdt) fpo = fopen(Ofile, "wbvq");

b1:	if(fget(Hdr, 4, fpi) != 4) goto b2;	// Get record type
	if(Hw(0) != 'KP') {					// Fail 'PK' id test
b2:		Error("?BadZIP%04x%04x %04x", Hw(0), Hw(2), Hw(4)); }
	Debug(("[%04x]", Hw(2) ))
	switch(Hw(2)) {	// Record type
	default	:	goto b2;
	case 0x0403:	Hoff = 0;		// Individual file
		FGet(Hdr+4, 0x1E-4);
		CMl = 0;
		if(ProcessFile(O_FIL, 'F')) ++ADTcount1;
		FPut(Hdr, 0x1E);
		FPut(Name, FNl);
		Skip(0, EXl);
		if(Flag & 0x08) Skip(0, 12);
		Skip(Hw(0x14), Hw(0x12));
		goto b1;
	case 0x0201:	Hoff = 2;		// Main directory
		FGet(Hdr+4, 0x2E-4);
		CMl = Hw(0x20);
		if(ProcessFile(O_DIR, 'D')) ++ADTcount2;
		FPut(Hdr, 0x2E);
		FPut(Name, FNl);
		Skip(0, EXl);
		Skip(0, CMl);
		goto b1;
	case 0x0605:					// End
		FPut(Hdr, 4); }
	Wnl();

	if(fpo) {	// Updating, copy any remaining
		while( (i = getc(fpi)) != EOF)
			putc(i, fpo);
		fclose(fpo); }
	fclose(fpi);

	if(ADTcount1|ADTcount2) {	// Timestamps adjust
		Pr("%u+%u entries adjusted!", ADTcount1, ADTcount2);
		if(Opt & O_ROZ) {	// Replace Original Zip
			if(Opt & O_DBG) strcpy(Ifile, "R:\\TST.ZIP");
			Dpr(" REP`%s`", Ifile);
			fpi = fopen(Ofile, "rbvq");
			fpo = fopen(Ifile, "wbvq");
			while(i = fget(Pool, sizeof(Pool), fpi)) {
				fput(Pool, i, fpo);
				if(i != sizeof(Pool))
					break; }
			fclose(fpo);
			fclose(fpi); } }
	if(Opt & O_ROZ) {		// Delete temp file
		Dpr(" DEL`%s`", Ofile);
		delete(Ofile); }
	Wnl("\n");
}
